"use strict";
var chalk = require('chalk');
var Promise = require('any-promise');
var archy = require('archy');
var os = require('os');
var pkg = require('../../package.json');
function log(message) {
    console.error(message);
}
exports.log = log;
function formatLine(color, type, line, prefix) {
    return chalk.bgBlack.white('typings') + " " + color(type) + " " + (prefix ? chalk.magenta(prefix + " ") : '') + line;
}
function logInfo(message, prefix) {
    var output = message.split(/\r?\n/g).map(function (line) {
        return formatLine(chalk.bgBlack.cyan, 'INFO', line, prefix);
    }).join('\n');
    log(output);
}
exports.logInfo = logInfo;
function logWarning(message, prefix) {
    var output = message.split(/\r?\n/g).map(function (line) {
        return formatLine(chalk.bgYellow.black, 'WARN', line, prefix);
    }).join('\n');
    log(output);
}
exports.logWarning = logWarning;
function logError(message, prefix) {
    var output = message.split(/\r?\n/g).map(function (line) {
        return formatLine(chalk.bgBlack.red, 'ERR!', line, prefix);
    }).join('\n');
    log(output);
}
exports.logError = logError;
function handle(promise, options) {
    return Promise.resolve(promise).catch(function (err) { return handleError(err, options); });
}
exports.handle = handle;
function handleError(error, options) {
    var cause = error;
    logError(error.message, 'message');
    while (cause = cause.cause) {
        logError(cause.message, 'caused by');
    }
    if (options.verbose && error.stack) {
        log('');
        logError(error.stack, 'stack');
    }
    log('');
    logError(process.cwd(), 'cwd');
    logError(os.type() + " " + os.release(), 'system');
    logError(process.argv.map(JSON.stringify).join(' '), 'command');
    logError(process.version, 'node -v');
    logError(pkg.version, "typings -v");
    if (error.code) {
        logError(error.code, 'code');
    }
    log('');
    logError('If you need help, you may report this error at:');
    logError("  <https://github.com/typings/typings/issues>");
    process.exit(1);
}
exports.handleError = handleError;
function archifyDependencyTree(options) {
    var result = {
        label: options.name,
        nodes: []
    };
    function traverse(result, tree) {
        var nodes = result.nodes;
        for (var _i = 0, _a = Object.keys(tree.dependencies).sort(); _i < _a.length; _i++) {
            var name_1 = _a[_i];
            nodes.push(traverse({
                label: name_1,
                nodes: []
            }, tree.dependencies[name_1]));
        }
        for (var _b = 0, _c = Object.keys(tree.devDependencies).sort(); _b < _c.length; _b++) {
            var name_2 = _c[_b];
            nodes.push(traverse({
                label: name_2 + " " + chalk.gray('(dev)'),
                nodes: []
            }, tree.devDependencies[name_2]));
        }
        for (var _d = 0, _e = Object.keys(tree.ambientDependencies).sort(); _d < _e.length; _d++) {
            var name_3 = _e[_d];
            nodes.push(traverse({
                label: name_3 + " " + chalk.gray('(ambient)'),
                nodes: []
            }, tree.ambientDependencies[name_3]));
        }
        for (var _f = 0, _g = Object.keys(tree.ambientDevDependencies).sort(); _f < _g.length; _f++) {
            var name_4 = _g[_f];
            nodes.push(traverse({
                label: name_4 + " " + chalk.gray('(ambient dev)'),
                nodes: []
            }, tree.ambientDevDependencies[name_4]));
        }
        return result;
    }
    var archyTree = traverse(result, options.tree);
    if (archyTree.nodes.length === 0) {
        archyTree.nodes.push(chalk.gray('(No dependencies)'));
    }
    return archy(archyTree);
}
exports.archifyDependencyTree = archifyDependencyTree;
//# sourceMappingURL=cli.js.map