"use strict";
var UiGridMetrics = (function () {
    function UiGridMetrics() {
    }
    UiGridMetrics.prototype.getHeaderFont = function () {
        if (this.headerFont) {
            return this.headerFont;
        }
        var header = document.querySelector('.ui-grid-header-cell .ui-grid-cell-contents');
        if (!header) {
            throw new Error('not found: .ui-grid-header-cell .ui-grid-cell-contents');
        }
        var headerStyle = getComputedStyle(header);
        this.headerFont = UiGridMetrics.getFontStringFrom(headerStyle);
        return this.headerFont;
    };
    UiGridMetrics.prototype.getCellFont = function () {
        if (this.cellFont) {
            return this.cellFont;
        }
        var cell = document.querySelector('.ui-grid-cell > .ui-grid-cell-contents');
        if (!cell) {
            var element = document.createElement('div');
            element.className = 'ui-grid-cell-contents';
            element.style.cssFloat = 'left';
            angular.element(document.body).append(element);
            var cellStyle_1 = getComputedStyle(element);
            this.cellFont = UiGridMetrics.getFontStringFrom(cellStyle_1);
            angular.element(element).remove();
            return this.cellFont;
        }
        var cellStyle = getComputedStyle(cell);
        this.cellFont = UiGridMetrics.getFontStringFrom(cellStyle);
        return this.cellFont;
    };
    UiGridMetrics.prototype.getPadding = function () {
        if (this.padding) {
            return this.padding;
        }
        var header = document.querySelector('.ui-grid-header-cell .ui-grid-cell-contents');
        if (!header) {
            throw new Error('not found: .ui-grid-header-cell .ui-grid-cell-contents');
        }
        var _a = getComputedStyle(header), paddingLeft = _a.paddingLeft, paddingRight = _a.paddingRight;
        this.padding = parseInt(paddingLeft) + parseInt(paddingRight);
        return this.padding;
    };
    UiGridMetrics.prototype.getBorder = function () {
        if (this.border) {
            return this.border;
        }
        var header = document.querySelector('.ui-grid-header-cell');
        if (!header) {
            throw new Error('not found: .ui-grid-header-cell');
        }
        var borderRightWidth = getComputedStyle(header).borderRightWidth;
        this.border = parseInt(borderRightWidth);
        return this.border;
    };
    UiGridMetrics.prototype.getHeaderButtonsWidth = function () {
        // TODO: lets be more precise
        var HEADER_BUTTONS_WIDTH = 25;
        return HEADER_BUTTONS_WIDTH;
    };
    UiGridMetrics.getFontStringFrom = function (_a) {
        var fontStyle = _a.fontStyle, fontVariant = _a.fontVariant, fontWeight = _a.fontWeight, fontSize = _a.fontSize, fontFamily = _a.fontFamily;
        // in FF cssStyle.font may be '' so we need to collect it manually
        // font: [font-style||font-variant||font-weight] font-size [/line-height] font-family | inherit
        return fontStyle + " " + fontVariant + " " + fontWeight + " " + fontSize + " " + fontFamily;
    };
    return UiGridMetrics;
}());
exports.UiGridMetrics = UiGridMetrics;
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = UiGridMetrics;
//# sourceMappingURL=UiGridMetrics.js.map