"use strict";
var Measurer_1 = require('./Measurer');
var UiGridMetrics_1 = require('./UiGridMetrics');
var UiGridAutoFitColumnsService = (function () {
    /*@ngInject*/
    function UiGridAutoFitColumnsService($q, $filter) {
        this.$q = $q;
        this.$filter = $filter;
        this.gridMetrics = new UiGridMetrics_1.default();
    }
    UiGridAutoFitColumnsService.prototype.initializeGrid = function (grid) {
        grid.registerColumnBuilder(this.colAutoFitColumnBuilder.bind(this));
        grid.registerColumnsProcessor(this.columnsProcessor.bind(this), 60);
        UiGridAutoFitColumnsService.defaultGridOptions(grid.options);
    };
    UiGridAutoFitColumnsService.defaultGridOptions = function (gridOptions) {
        // true by default
        gridOptions.enableColumnAutoFit = gridOptions.enableColumnAutoFit !== false;
    };
    UiGridAutoFitColumnsService.prototype.getFilterIfExists = function (filterName) {
        try {
            return this.$filter(filterName);
        }
        catch (e) {
            return null;
        }
    };
    UiGridAutoFitColumnsService.prototype.getFilteredValue = function (value, cellFilter) {
        if (cellFilter && cellFilter !== '') {
            var filter = this.getFilterIfExists(cellFilter);
            if (filter) {
                value = filter(value);
            }
            else {
                // https://regex101.com/r/rC5eR5/2
                var re = /([^:]*):([^:]*):?([\s\S]+)?/;
                var matches = void 0;
                if ((matches = re.exec(cellFilter)) !== null) {
                    value = this.$filter(matches[1])(value, matches[2], matches[3]);
                }
            }
        }
        return value;
    };
    UiGridAutoFitColumnsService.prototype.colAutoFitColumnBuilder = function (colDef, col, gridOptions) {
        var promises = [];
        if (colDef.enableColumnAutoFit === undefined) {
            //TODO: make it as col.isResizable()
            if (UiGridAutoFitColumnsService.isResizable(colDef)) {
                colDef.enableColumnAutoFit = gridOptions.enableColumnAutoFit;
            }
            else {
                colDef.enableColumnAutoFit = false;
            }
        }
        return this.$q.all(promises);
    };
    UiGridAutoFitColumnsService.isResizable = function (colDef) {
        return !colDef.hasOwnProperty('width');
    };
    UiGridAutoFitColumnsService.prototype.columnsProcessor = function (renderedColumnsToProcess, rows) {
        var _this = this;
        if (!rows.length) {
            return renderedColumnsToProcess;
        }
        // TODO: respect existing colDef options
        // if (col.colDef.enableColumnAutoFitting === false) return;
        var optimalWidths = {};
        renderedColumnsToProcess.forEach(function (column) {
            if (column.colDef.enableColumnAutoFit) {
                var columnKey_1 = column.field || column.name;
                optimalWidths[columnKey_1] = Measurer_1.default.measureRoundedTextWidth(column.displayName, _this.gridMetrics.getHeaderFont()) + _this.gridMetrics.getHeaderButtonsWidth();
                rows.forEach(function (row) {
                    var cellText = row.grid.getCellValue(row, column);
                    if (!!column.colDef.cellFilter) {
                        cellText = _this.getFilteredValue(cellText, column.colDef.cellFilter);
                    }
                    var currentCellWidth = Measurer_1.default.measureRoundedTextWidth(cellText, _this.gridMetrics.getCellFont());
                    var optimalCellWidth = currentCellWidth > 300 ? 300 : currentCellWidth;
                    if (optimalCellWidth > optimalWidths[columnKey_1]) {
                        optimalWidths[columnKey_1] = optimalCellWidth;
                    }
                });
                column.colDef.width = optimalWidths[columnKey_1] + _this.gridMetrics.getPadding() + _this.gridMetrics.getBorder();
                column.updateColumnDef(column.colDef, false);
            }
        });
        return renderedColumnsToProcess;
    };
    return UiGridAutoFitColumnsService;
}());
exports.UiGridAutoFitColumnsService = UiGridAutoFitColumnsService;
//# sourceMappingURL=UiGridAutoFitColumnsService.js.map