(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("angular"));
	else if(typeof define === 'function' && define.amd)
		define(["angular"], factory);
	else {
		var a = typeof exports === 'object' ? factory(require("angular")) : factory(root["angular"]);
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(this, function(__WEBPACK_EXTERNAL_MODULE_1__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var angular = __webpack_require__(1);
	var UiGridAutoFitColumnsService_1 = __webpack_require__(2);
	var UiGridAutoFitColumnsDirective_1 = __webpack_require__(5);
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.default = angular.module('ui.grid.autoFitColumns', ['ui.grid'])
	    .service('uiGridAutoFitColumnsService', UiGridAutoFitColumnsService_1.UiGridAutoFitColumnsService)
	    .directive('uiGridAutoFitColumns', UiGridAutoFitColumnsDirective_1.UiGridAutoFitColumnsDirective)
	    .name;


/***/ },
/* 1 */
/***/ function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_1__;

/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var Measurer_1 = __webpack_require__(3);
	var UiGridMetrics_1 = __webpack_require__(4);
	var UiGridAutoFitColumnsService = (function () {
	    /*@ngInject*/
	    UiGridAutoFitColumnsService.$inject = ["$q", "$filter"];
	    function UiGridAutoFitColumnsService($q, $filter) {
	        this.$q = $q;
	        this.$filter = $filter;
	        this.gridMetrics = new UiGridMetrics_1.default();
	    }
	    UiGridAutoFitColumnsService.prototype.initializeGrid = function (grid) {
	        grid.registerColumnBuilder(this.colAutoFitColumnBuilder.bind(this));
	        grid.registerColumnsProcessor(this.columnsProcessor.bind(this), 60);
	        UiGridAutoFitColumnsService.defaultGridOptions(grid.options);
	    };
	    UiGridAutoFitColumnsService.defaultGridOptions = function (gridOptions) {
	        // true by default
	        gridOptions.enableColumnAutoFit = gridOptions.enableColumnAutoFit !== false;
	    };
	    UiGridAutoFitColumnsService.prototype.getFilterIfExists = function (filterName) {
	        try {
	            return this.$filter(filterName);
	        }
	        catch (e) {
	            return null;
	        }
	    };
	    UiGridAutoFitColumnsService.prototype.getFilteredValue = function (value, cellFilter) {
	        if (cellFilter && cellFilter !== '') {
	            var filter = this.getFilterIfExists(cellFilter);
	            if (filter) {
	                value = filter(value);
	            }
	            else {
	                // https://regex101.com/r/rC5eR5/2
	                var re = /([^:]*):([^:]*):?([\s\S]+)?/;
	                var matches = void 0;
	                if ((matches = re.exec(cellFilter)) !== null) {
	                    value = this.$filter(matches[1])(value, matches[2], matches[3]);
	                }
	            }
	        }
	        return value;
	    };
	    UiGridAutoFitColumnsService.prototype.colAutoFitColumnBuilder = function (colDef, col, gridOptions) {
	        var promises = [];
	        if (colDef.enableColumnAutoFit === undefined) {
	            //TODO: make it as col.isResizable()
	            if (UiGridAutoFitColumnsService.isResizable(colDef)) {
	                colDef.enableColumnAutoFit = gridOptions.enableColumnAutoFit;
	            }
	            else {
	                colDef.enableColumnAutoFit = false;
	            }
	        }
	        return this.$q.all(promises);
	    };
	    UiGridAutoFitColumnsService.isResizable = function (colDef) {
	        return !colDef.hasOwnProperty('width');
	    };
	    UiGridAutoFitColumnsService.prototype.columnsProcessor = function (renderedColumnsToProcess, rows) {
	        var _this = this;
	        if (!rows.length) {
	            return renderedColumnsToProcess;
	        }
	        // TODO: respect existing colDef options
	        // if (col.colDef.enableColumnAutoFitting === false) return;
	        var optimalWidths = {};
	        renderedColumnsToProcess.forEach(function (column) {
	            if (column.colDef.enableColumnAutoFit) {
	                var columnKey_1 = column.field || column.name;
	                optimalWidths[columnKey_1] = Measurer_1.default.measureRoundedTextWidth(column.displayName, _this.gridMetrics.getHeaderFont()) + _this.gridMetrics.getHeaderButtonsWidth();
	                rows.forEach(function (row) {
	                    var cellText = row.grid.getCellValue(row, column);
	                    if (!!column.colDef.cellFilter) {
	                        cellText = _this.getFilteredValue(cellText, column.colDef.cellFilter);
	                    }
	                    var currentCellWidth = Measurer_1.default.measureRoundedTextWidth(cellText, _this.gridMetrics.getCellFont());
	                    var optimalCellWidth = currentCellWidth > 300 ? 300 : currentCellWidth;
	                    if (optimalCellWidth > optimalWidths[columnKey_1]) {
	                        optimalWidths[columnKey_1] = optimalCellWidth;
	                    }
	                });
	                column.colDef.width = optimalWidths[columnKey_1] + _this.gridMetrics.getPadding() + _this.gridMetrics.getBorder();
	                column.updateColumnDef(column.colDef, false);
	            }
	        });
	        return renderedColumnsToProcess;
	    };
	    return UiGridAutoFitColumnsService;
	}());
	exports.UiGridAutoFitColumnsService = UiGridAutoFitColumnsService;


/***/ },
/* 3 */
/***/ function(module, exports) {

	"use strict";
	var Measurer = (function () {
	    function Measurer() {
	    }
	    Measurer.measureTextWidth = function (text, font) {
	        var canvas = Measurer.canvas || (Measurer.canvas = document.createElement('canvas'));
	        var context = canvas.getContext('2d');
	        context.font = font;
	        var metrics = context.measureText(text);
	        return metrics.width;
	    };
	    Measurer.measureRoundedTextWidth = function (text, font) {
	        var width = Measurer.measureTextWidth(text, font);
	        return Math.floor(width) + 1;
	    };
	    return Measurer;
	}());
	exports.Measurer = Measurer;
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.default = Measurer;


/***/ },
/* 4 */
/***/ function(module, exports) {

	"use strict";
	var UiGridMetrics = (function () {
	    function UiGridMetrics() {
	    }
	    UiGridMetrics.prototype.getHeaderFont = function () {
	        if (this.headerFont) {
	            return this.headerFont;
	        }
	        var header = document.querySelector('.ui-grid-header-cell .ui-grid-cell-contents');
	        if (!header) {
	            throw new Error('not found: .ui-grid-header-cell .ui-grid-cell-contents');
	        }
	        var headerStyle = getComputedStyle(header);
	        this.headerFont = UiGridMetrics.getFontStringFrom(headerStyle);
	        return this.headerFont;
	    };
	    UiGridMetrics.prototype.getCellFont = function () {
	        if (this.cellFont) {
	            return this.cellFont;
	        }
	        var cell = document.querySelector('.ui-grid-cell > .ui-grid-cell-contents');
	        if (!cell) {
	            var element = document.createElement('div');
	            element.className = 'ui-grid-cell-contents';
	            element.style.cssFloat = 'left';
	            angular.element(document.body).append(element);
	            var cellStyle_1 = getComputedStyle(element);
	            this.cellFont = UiGridMetrics.getFontStringFrom(cellStyle_1);
	            angular.element(element).remove();
	            return this.cellFont;
	        }
	        var cellStyle = getComputedStyle(cell);
	        this.cellFont = UiGridMetrics.getFontStringFrom(cellStyle);
	        return this.cellFont;
	    };
	    UiGridMetrics.prototype.getPadding = function () {
	        if (this.padding) {
	            return this.padding;
	        }
	        var header = document.querySelector('.ui-grid-header-cell .ui-grid-cell-contents');
	        if (!header) {
	            throw new Error('not found: .ui-grid-header-cell .ui-grid-cell-contents');
	        }
	        var _a = getComputedStyle(header), paddingLeft = _a.paddingLeft, paddingRight = _a.paddingRight;
	        this.padding = parseInt(paddingLeft) + parseInt(paddingRight);
	        return this.padding;
	    };
	    UiGridMetrics.prototype.getBorder = function () {
	        if (this.border) {
	            return this.border;
	        }
	        var header = document.querySelector('.ui-grid-header-cell');
	        if (!header) {
	            throw new Error('not found: .ui-grid-header-cell');
	        }
	        var borderRightWidth = getComputedStyle(header).borderRightWidth;
	        this.border = parseInt(borderRightWidth);
	        return this.border;
	    };
	    UiGridMetrics.prototype.getHeaderButtonsWidth = function () {
	        // TODO: lets be more precise
	        var HEADER_BUTTONS_WIDTH = 25;
	        return HEADER_BUTTONS_WIDTH;
	    };
	    UiGridMetrics.getFontStringFrom = function (_a) {
	        var fontStyle = _a.fontStyle, fontVariant = _a.fontVariant, fontWeight = _a.fontWeight, fontSize = _a.fontSize, fontFamily = _a.fontFamily;
	        // in FF cssStyle.font may be '' so we need to collect it manually
	        // font: [font-style||font-variant||font-weight] font-size [/line-height] font-family | inherit
	        return fontStyle + " " + fontVariant + " " + fontWeight + " " + fontSize + " " + fontFamily;
	    };
	    return UiGridMetrics;
	}());
	exports.UiGridMetrics = UiGridMetrics;
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.default = UiGridMetrics;


/***/ },
/* 5 */
/***/ function(module, exports) {

	"use strict";
	/*@ngInject*/
	UiGridAutoFitColumnsDirective.$inject = ["uiGridAutoFitColumnsService"];
	function UiGridAutoFitColumnsDirective(uiGridAutoFitColumnsService) {
	    return {
	        replace: true,
	        priority: 0,
	        require: '^uiGrid',
	        scope: false,
	        compile: function () {
	            return {
	                pre: function ($scope, $elm, $attrs, uiGridCtrl) {
	                    uiGridAutoFitColumnsService.initializeGrid(uiGridCtrl.grid);
	                }
	            };
	        }
	    };
	}
	exports.UiGridAutoFitColumnsDirective = UiGridAutoFitColumnsDirective;


/***/ }
/******/ ])
});
;
//# sourceMappingURL=autoFitColumns.js.map