import { IQService } from 'angular';
import { IColumnDef, IGridColumn, IGridInstance, IGridOptions, IGridRow } from 'ui-grid';
interface IExtendedColumnDef extends IColumnDef {
    enableColumnAutoFit: boolean;
}
interface IExtendedGridColumn extends IGridColumn {
    colDef: IExtendedColumnDef;
}
interface IExtendedGridInstance extends IGridInstance {
    options: IExtendedGridOptions;
}
interface IExtendedGridOptions extends IGridOptions {
    enableColumnAutoFit: boolean;
}
export declare class UiGridAutoFitColumnsService {
    private $q;
    static $inject: string[];
    private gridMetrics;
    constructor($q: IQService);
    initializeGrid(grid: IExtendedGridInstance): void;
    static defaultGridOptions(gridOptions: IExtendedGridOptions): void;
    colAutoFitColumnBuilder(colDef: IExtendedColumnDef, col: IExtendedGridColumn, gridOptions: IExtendedGridOptions): import("angular").IPromise<any[]>;
    static isResizable(colDef: IExtendedColumnDef): boolean;
    columnsProcessor(renderedColumnsToProcess?: Array<IExtendedGridColumn>, rows?: Array<IGridRow>): IExtendedGridColumn[];
}
export {};
