"use strict";
/**
 * @internalapi
 * @module vanilla
 */
/** */
var index_1 = require("../common/index");
var common_1 = require("../common/common");
var beforeAfterSubstr = function (char) { return function (str) {
    if (!str)
        return ["", ""];
    var idx = str.indexOf(char);
    if (idx === -1)
        return [str, ""];
    return [str.substr(0, idx), str.substr(idx + 1)];
}; };
exports.splitHash = beforeAfterSubstr("#");
exports.splitQuery = beforeAfterSubstr("?");
exports.splitEqual = beforeAfterSubstr("=");
exports.trimHashVal = function (str) { return str ? str.replace(/^#/, "") : ""; };
exports.keyValsToObjectR = function (accum, _a) {
    var key = _a[0], val = _a[1];
    if (!accum.hasOwnProperty(key)) {
        accum[key] = val;
    }
    else if (index_1.isArray(accum[key])) {
        accum[key].push(val);
    }
    else {
        accum[key] = [accum[key], val];
    }
    return accum;
};
exports.getParams = function (queryString) {
    return queryString.split("&").filter(common_1.identity).map(exports.splitEqual).reduce(exports.keyValsToObjectR, {});
};
function parseUrl(url) {
    var orEmptyString = function (x) { return x || ""; };
    var _a = exports.splitHash(url).map(orEmptyString), beforehash = _a[0], hash = _a[1];
    var _b = exports.splitQuery(beforehash).map(orEmptyString), path = _b[0], search = _b[1];
    return { path: path, search: search, hash: hash, url: url };
}
exports.parseUrl = parseUrl;
exports.buildUrl = function (loc) {
    var path = loc.path();
    var searchObject = loc.search();
    var hash = loc.hash();
    var search = Object.keys(searchObject).map(function (key) {
        var param = searchObject[key];
        var vals = index_1.isArray(param) ? param : [param];
        return vals.map(function (val) { return key + "=" + val; });
    }).reduce(common_1.unnestR, []).join("&");
    return path + (search ? "?" + search : "") + (hash ? "#" + hash : "");
};
function locationPluginFactory(name, isHtml5, serviceClass, configurationClass) {
    return function (router) {
        var service = router.locationService = new serviceClass(router);
        var configuration = router.locationConfig = new configurationClass(router, isHtml5);
        function dispose(router) {
            router.dispose(service);
            router.dispose(configuration);
        }
        return { name: name, service: service, configuration: configuration, dispose: dispose };
    };
}
exports.locationPluginFactory = locationPluginFactory;
//# sourceMappingURL=utils.js.map