"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
/**
 * The UI-Router Angular 2 directives:
 *
 * - [[UiView]]: A viewport for routed components
 * - [[UiSref]]: A state ref to a target state; navigates when clicked
 * - [[UiSrefActive]]: (and `UiSrefActiveEq`) Adds a css class when a UiSref's target state (or a child state) is active
 *
 * @preferred @module ng2_directives
 */ /** */
var uiSref_1 = require("../ng2/uiSref");
var uiSrefActive_1 = require("../ng2/uiSrefActive");
var uiView_1 = require("../ng2/uiView");
var uiSrefStatus_1 = require("./uiSrefStatus");
__export(require("./uiView"));
__export(require("./uiSref"));
__export(require("./uiSrefStatus"));
__export(require("./uiSrefActive"));
/**
 * References to the UI-Router directive classes, for use within a @Component's `directives:` property
 *
 * @example
 * ```js
 *
 * Component({
 *   selector: 'my-cmp',
 *   directives: [UIROUTER_DIRECTIVES],
 *   template: '<a uiSref="foo">Foo</a>'
 * })
 * ```
 */
exports.UIROUTER_DIRECTIVES = [uiSref_1.UiSref, uiSref_1.AnchorUiSref, uiView_1.UiView, uiSrefActive_1.UiSrefActive, uiSrefStatus_1.UiSrefStatus];
//# sourceMappingURL=directives.js.map