"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var common_1 = require("@angular/common");
var core_1 = require("@angular/core");
var coreservices_1 = require("../common/coreservices");
var predicates_1 = require("../common/predicates");
var common_2 = require("../common/common");
var strings_1 = require("../common/strings");
var splitOnHash = strings_1.beforeAfterSubstr("#");
var splitOnEquals = strings_1.beforeAfterSubstr("=");
var splitOnQuestionMark = strings_1.beforeAfterSubstr("?");
var UIRouterLocation = (function () {
    function UIRouterLocation(locationStrategy, platformLocation) {
        this.locationStrategy = locationStrategy;
        this.platformLocation = platformLocation;
        this.hashPrefix = "";
        this.isHashBang = locationStrategy instanceof common_1.HashLocationStrategy;
    }
    UIRouterLocation.prototype.init = function () {
        var _this = this;
        var loc = coreservices_1.services.location;
        var locSt = this.locationStrategy;
        if (this.isHashBang) {
            loc.hash = function () {
                return splitOnHash(splitOnHash(_this.platformLocation.hash)[1])[1];
            };
        }
        else {
            loc.hash = function () {
                return splitOnHash(_this.platformLocation.hash)[1];
            };
        }
        loc.path = function () {
            return splitOnHash(splitOnQuestionMark(locSt.path())[0])[0];
        };
        loc.search = function () {
            var queryString = splitOnHash(splitOnQuestionMark(locSt.path())[1])[0];
            return queryString.split("&").map(function (kv) { return splitOnEquals(kv); }).reduce(common_2.applyPairs, {});
        };
        loc.url = function (url) {
            if (predicates_1.isDefined(url)) {
                var split = splitOnQuestionMark(url);
                locSt.pushState(null, null, split[0], split[1]);
            }
            return locSt.path();
        };
        loc.replace = function () {
            console.log(new Error('$location.replace() not impl'));
        };
        loc.onChange = function (cb) { return locSt.onPopState(cb); };
        var locCfg = coreservices_1.services.locationConfig;
        locCfg.port = function () { return null; };
        locCfg.protocol = function () { return null; };
        locCfg.host = function () { return null; };
        locCfg.baseHref = function () { return locSt.getBaseHref(); };
        locCfg.html5Mode = function () { return !_this.isHashBang; };
        locCfg.hashPrefix = function (newprefix) {
            if (predicates_1.isDefined(newprefix)) {
                _this.hashPrefix = newprefix;
            }
            return _this.hashPrefix;
        };
    };
    UIRouterLocation = __decorate([
        core_1.Injectable(), 
        __metadata('design:paramtypes', [common_1.LocationStrategy, common_1.PlatformLocation])
    ], UIRouterLocation);
    return UIRouterLocation;
}());
exports.UIRouterLocation = UIRouterLocation;
//# sourceMappingURL=location.js.map