"use strict";
/**
 * # UI-Router for Angular 2
 *
 * For the quick start repository, please see http://github.com/ui-router/quickstart-ng2
 *
 * Getting started:
 *
 * - Use npm. Add a dependency on latest `ui-router-ng2`
 * - Import UI-Router classes directly from `"ui-router-ng2"`
 *
 * ```js
 * import {StateRegistry} from "ui-router-ng2";
 * ```
 *
 * - When defining a component, add the [[UIROUTER_DIRECTIVES]] to `directives:` array.
 * - Either bootstrap a [[UiView]] component, or add a `<ui-view></ui-view>` viewport to your root component.
 * - Create application states (as defined by [[Ng2StateDeclaration]]) which will fill in the viewports.
 * - Create a [[UIRouterConfig]], and register your states in the [[UIRouterConfig.configure]] function.
 *
 * ```js
 * import {UIRouter} from "ui-router-ng2";
 * import {INITIAL_STATES} from "./app.states";
 * @ Injectable()
 * export class MyUIRouterConfig {
 *   configure(uiRouter: UIRouter) {
 *     INITIAL_STATES.forEach(function(state) {
 *       uiRouter.stateRegistry.register(state));
 *     });
 *   }
 * }
 * ```
 *
 * - When bootstrapping: include the [[UIROUTER_PROVIDERS]] and define a provider for your [[UIRouterConfig]]
 *
 * ```js
 * import {provide} from "@angular/core";
 * import {bootstrap} from 'angular2/platform/browser';
 * import {UIRouterConfig, UiView, UIROUTER_PROVIDERS} from "ui-router-ng2";
 * import {MyUIRouterConfig} from "./router.config";
 *
 * bootstrap(UiView, [
 *     ...UIROUTER_PROVIDERS,
 *     provide(UIRouterConfig, { useClass: MyUIRouterConfig })
 * ]);
 * ```
 *
 * @preferred @module ng2
 */ /** */
var core_1 = require("@angular/core");
var router_1 = require("../router");
var stateRegistry_1 = require("../state/stateRegistry");
var stateService_1 = require("../state/stateService");
var transitionService_1 = require("../transition/transitionService");
var urlMatcherFactory_1 = require("../url/urlMatcherFactory");
var urlRouter_1 = require("../url/urlRouter");
var view_1 = require("../view/view");
var uiView_1 = require("./uiView");
var viewsBuilder_1 = require("./viewsBuilder");
var uiRouterConfig_1 = require("./uiRouterConfig");
var globals_1 = require("../globals");
var location_1 = require("./location");
var uiRouterFactory = function (routerConfig, location) {
    var router = new router_1.UIRouter();
    location.init();
    router.viewService.viewConfigFactory("ng2", function (node, config) { return new viewsBuilder_1.Ng2ViewConfig(node, config); });
    router.stateRegistry.decorator('views', viewsBuilder_1.ng2ViewsBuilder);
    router.stateRegistry.stateQueue.autoFlush(router.stateService);
    routerConfig.configure(router);
    if (!router.urlRouterProvider.interceptDeferred) {
        router.urlRouter.listen();
        router.urlRouter.sync();
    }
    return router;
};
/**
 * The UI-Router providers, for use in your application bootstrap
 *
 * @example
 * ```js
 *
 * bootstrap(UiView, [
 *     ...UIROUTER_PROVIDERS,
 *     ...HTTP_PROVIDERS,
 *     provide(UIRouterConfig, { useClass: MyUIRouterConfig })
 * ]);
 * ```
 */
exports.UIROUTER_PROVIDERS = [
    core_1.provide(router_1.UIRouter, { useFactory: uiRouterFactory, deps: [uiRouterConfig_1.UIRouterConfig, location_1.UIRouterLocation] }),
    core_1.provide(location_1.UIRouterLocation, { useClass: location_1.UIRouterLocation }),
    core_1.provide(stateService_1.StateService, { useFactory: function (r) { return r.stateService; }, deps: [router_1.UIRouter] }),
    core_1.provide(transitionService_1.TransitionService, { useFactory: function (r) { return r.transitionService; }, deps: [router_1.UIRouter] }),
    core_1.provide(urlMatcherFactory_1.UrlMatcherFactory, { useFactory: function (r) { return r.urlMatcherFactory; }, deps: [router_1.UIRouter] }),
    core_1.provide(urlRouter_1.UrlRouter, { useFactory: function (r) { return r.urlRouter; }, deps: [router_1.UIRouter] }),
    core_1.provide(view_1.ViewService, { useFactory: function (r) { return r.viewService; }, deps: [router_1.UIRouter] }),
    core_1.provide(stateRegistry_1.StateRegistry, { useFactory: function (r) { return r.stateRegistry; }, deps: [router_1.UIRouter] }),
    core_1.provide(globals_1.UIRouterGlobals, { useFactory: function (r) { return r.globals; }, deps: [router_1.UIRouter] }),
    core_1.provide(uiView_1.UiView.PARENT_INJECT, { useFactory: function (r) { return { fqn: null, context: r.root() }; }, deps: [stateRegistry_1.StateRegistry] })
];
//# sourceMappingURL=providers.js.map