"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
/** @module ng2_directives */ /** */
var router_1 = require("../router");
var core_1 = require("@angular/core");
var core_2 = require("@angular/core");
var core_3 = require("@angular/core");
var core_4 = require("@angular/core");
var uiView_1 = require("./uiView");
var common_1 = require("../common/common");
/** @hidden */
var AnchorUiSref = (function () {
    function AnchorUiSref(_el, _renderer) {
        this._el = _el;
        this._renderer = _renderer;
    }
    AnchorUiSref.prototype.update = function (href) {
        this._renderer.setElementProperty(this._el.nativeElement, 'href', href);
    };
    AnchorUiSref = __decorate([
        core_1.Directive({ selector: 'a[uiSref]' }), 
        __metadata('design:paramtypes', [core_3.ElementRef, core_4.Renderer])
    ], AnchorUiSref);
    return AnchorUiSref;
}());
exports.AnchorUiSref = AnchorUiSref;
/**
 * A directive when clicked, initiates a [[Transition]] to a [[TargetState]].
 *
 * ### Purpose
 *
 * This directive is applied to anchor tags (`<a>`) or any other clickable element.  It is a state reference (or sref --
 * similar to an href).  When clicked, the directive will transition to that state by calling [[StateService.go]],
 * and optionally supply state parameter values and transition options.
 *
 * When this directive is on an anchor tag, it will also add an `href` attribute to the anchor.
 *
 * ### Selector
 *
 * - `[uiSref]`: The directive is created as an attribute on an element, e.g., `<a uiSref></a>`
 *
 * ### Inputs
 *
 * - `uiSref`: the target state's name, e.g., `uiSref="foostate"`.  If a component template uses a relative `uiSref`,
 * e.g., `uiSref=".child"`, the reference is relative to that component's state.
 *
 * - `uiParams`: any target state parameter values, as an object, e.g., `[uiParams]="{ fooId: bar.fooId }"`
 *
 * - `uiOptions`: [[TransitionOptions]], e.g., `[uiOptions]="{ inherit: false }"`
 *
 * @example
 * ```html
 *
 * <!-- Targets bar state' -->
 * <a uiSref="bar">Bar</a>
 *
 * <!-- Assume this component's state is "foo".
 *      Relatively targets "foo.child" -->
 * <a uiSref=".child">Foo Child</a>
 *
 * <!-- Targets "bar" state and supplies parameter value -->
 * <a uiSref="bar" [uiParams]="{ barId: foo.barId }">Bar {{foo.barId}}</a>
 *
 * <!-- Targets "bar" state and parameter, doesn't inherit existing parameters-->
 * <a uiSref="bar" [uiParams]="{ barId: foo.barId }" [uiOptions]="{ inherit: false }">Bar {{foo.barId}}</a>
 * ```
 */
var UiSref = (function () {
    function UiSref(_router, parent, _anchorUiSref) {
        this._router = _router;
        this.parent = parent;
        this._anchorUiSref = _anchorUiSref;
    }
    Object.defineProperty(UiSref.prototype, "uiSref", {
        set: function (val) { this.state = val; this.update(); },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(UiSref.prototype, "uiParams", {
        set: function (val) { this.params = val; this.update(); },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(UiSref.prototype, "uiOptions", {
        set: function (val) { this.options = val; this.update(); },
        enumerable: true,
        configurable: true
    });
    UiSref.prototype.ngOnInit = function () {
        this.update();
    };
    UiSref.prototype.update = function () {
        if (this._anchorUiSref) {
            this._anchorUiSref.update(this._router.stateService.href(this.state, this.params, this.getOptions()));
        }
    };
    UiSref.prototype.getOptions = function () {
        var defOpts = { relative: this.parent && this.parent.context && this.parent.context.name, inherit: true };
        return common_1.extend(defOpts, this.options || {});
    };
    UiSref.prototype.go = function () {
        this._router.stateService.go(this.state, this.params, this.getOptions());
        return false;
    };
    __decorate([
        core_1.Input('uiSref'), 
        __metadata('design:type', String)
    ], UiSref.prototype, "state", void 0);
    __decorate([
        core_1.Input('uiParams'), 
        __metadata('design:type', Object)
    ], UiSref.prototype, "params", void 0);
    __decorate([
        core_1.Input('uiOptions'), 
        __metadata('design:type', Object)
    ], UiSref.prototype, "options", void 0);
    UiSref = __decorate([
        core_1.Directive({
            selector: '[uiSref]',
            host: { '(click)': 'go()' }
        }),
        __param(1, core_1.Inject(uiView_1.UiView.PARENT_INJECT)),
        __param(2, core_2.Optional()), 
        __metadata('design:paramtypes', [router_1.UIRouter, Object, AnchorUiSref])
    ], UiSref);
    return UiSref;
}());
exports.UiSref = UiSref;
//# sourceMappingURL=uiSref.js.map