"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
/** @module ng2_directives */ /** */
var core_1 = require("@angular/core");
var uiSrefStatus_1 = require("./uiSrefStatus");
/**
 * A directive that adds a CSS class when a `uiSref` is active.
 *
 * ### Purpose
 *
 * This directive should be paired with a [[UiSref]], and is used to apply a CSS class to the element when
 * the state that the `uiSref` targets is active.
 *
 * ### Selectors
 *
 * - `[uiSrefActive]`: When this selector is used, the class is added when the target state or any
 * child of the target state is active
 * - `[uiSrefActiveEq]`: When this selector is used, the class is added when the target state is directly active
 *
 * ### Inputs
 *
 * - `uiSrefActive`/`uiSrefActiveEq`: one or more CSS classes to add to the element, when active
 *
 * @example
 * ```html
 *
 * <a uiSref="foo" uiSrefActive="active">Foo</a>
 * <a uiSref="foo.bar" [uiParams]="{ id: bar.id }" uiSrefActive="active">Foo Bar #{{bar.id}}</a>
 * ```
 */
var UiSrefActive = (function () {
    function UiSrefActive(uiSrefStatus, rnd, host) {
        var _this = this;
        this._classes = [];
        this._classesEq = [];
        uiSrefStatus.uiSrefStatus.subscribe(function (next) {
            _this._classes.forEach(function (cls) { return rnd.setElementClass(host.nativeElement, cls, next.active); });
            _this._classesEq.forEach(function (cls) { return rnd.setElementClass(host.nativeElement, cls, next.exact); });
        });
    }
    Object.defineProperty(UiSrefActive.prototype, "active", {
        set: function (val) { this._classes = val.split("\s+"); },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(UiSrefActive.prototype, "activeEq", {
        set: function (val) { this._classesEq = val.split("\s+"); },
        enumerable: true,
        configurable: true
    });
    ;
    __decorate([
        core_1.Input('uiSrefActive'), 
        __metadata('design:type', Object), 
        __metadata('design:paramtypes', [Object])
    ], UiSrefActive.prototype, "active", null);
    __decorate([
        core_1.Input('uiSrefActiveEq'), 
        __metadata('design:type', Object), 
        __metadata('design:paramtypes', [Object])
    ], UiSrefActive.prototype, "activeEq", null);
    UiSrefActive = __decorate([
        core_1.Directive({
            selector: '[uiSrefActive],[uiSrefActiveEq]'
        }),
        __param(2, core_1.Host()), 
        __metadata('design:paramtypes', [uiSrefStatus_1.UiSrefStatus, core_1.Renderer, core_1.ElementRef])
    ], UiSrefActive);
    return UiSrefActive;
}());
exports.UiSrefActive = UiSrefActive;
//# sourceMappingURL=uiSrefActive.js.map