/** @module ng2_directives */ /** */
import { EventEmitter } from "@angular/core";
import { StateService } from "../state/stateService";
import { UiSref } from "./uiSref";
import { TransitionService } from "../transition/transitionService";
import { UIRouterGlobals } from "../globals";
/**
 * uiSref status booleans
 */
export interface SrefStatus {
    /** The sref's target state (or one of its children) is currently active */
    active: boolean;
    /** The sref's target state is currently active */
    exact: boolean;
    /** A transition is entering the sref's target state */
    entering: boolean;
    /** A transition is exiting the sref's target state */
    exiting: boolean;
}
/**
 * A directive (which pairs with a [[UiSref]]) and emits events when the UiSref status changes.
 *
 * This directive is used by the [[UiSrefActive]] directive.
 *
 * The event emitted is of type [[SrefStatus]], and has boolean values for `active`, `exact`, `entering`, and `exiting`
 *
 * The values from this event can be captured and stored on a component, then applied (perhaps using ngClass).
 *
 * This API is subject to change.
 */
export declare class UiSrefStatus {
    private _globals;
    private _stateService;
    sref: UiSref;
    private _deregisterHook;
    uiSrefStatus: EventEmitter<SrefStatus>;
    status: SrefStatus;
    constructor(transitionService: TransitionService, _globals: UIRouterGlobals, _stateService: StateService, sref: UiSref);
    ngOnInit(): void;
    ngOnDestroy(): void;
    private _setStatus(status);
    private processTransition($transition$);
}
