"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
/** @module ng2_directives */ /** */
var core_1 = require("@angular/core");
var stateService_1 = require("../state/stateService");
var uiSref_1 = require("./uiSref");
var transitionService_1 = require("../transition/transitionService");
var common_1 = require("../common/common");
var globals_1 = require("../globals");
var param_1 = require("../params/param");
var pathFactory_1 = require("../path/pathFactory");
/**
 * A directive (which pairs with a [[UiSref]]) and emits events when the UiSref status changes.
 *
 * This directive is used by the [[UiSrefActive]] directive.
 *
 * The event emitted is of type [[SrefStatus]], and has boolean values for `active`, `exact`, `entering`, and `exiting`
 *
 * The values from this event can be captured and stored on a component, then applied (perhaps using ngClass).
 *
 * This API is subject to change.
 */
var UiSrefStatus = (function () {
    function UiSrefStatus(transitionService, _globals, _stateService, sref) {
        var _this = this;
        this._globals = _globals;
        this._stateService = _stateService;
        this.sref = sref;
        // current statuses of the state/params the uiSref directive is linking to
        this.uiSrefStatus = new core_1.EventEmitter(false);
        this.status = {
            active: false,
            exact: false,
            entering: false,
            exiting: false
        };
        this._deregisterHook = transitionService.onStart({}, function ($transition$) { return _this.processTransition($transition$); });
    }
    UiSrefStatus.prototype.ngOnInit = function () {
        var lastTrans = this._globals.transitionHistory.peekTail();
        if (lastTrans != null) {
            this.processTransition(lastTrans);
        }
    };
    UiSrefStatus.prototype.ngOnDestroy = function () {
        if (this._deregisterHook) {
            this._deregisterHook();
        }
        this._deregisterHook = null;
    };
    UiSrefStatus.prototype._setStatus = function (status) {
        this.status = status;
        this.uiSrefStatus.emit(status);
    };
    UiSrefStatus.prototype.processTransition = function ($transition$) {
        var _this = this;
        var sref = this.sref;
        var status = {
            active: false,
            exact: false,
            entering: false,
            exiting: false
        };
        var srefTarget = this._stateService.target(sref.state, sref.params, sref.getOptions());
        if (!srefTarget.exists()) {
            return this._setStatus(status);
        }
        /**
         * Returns a Predicate<Node[]> that returns true when the target state (and any param values)
         * match the (tail of) the path, and the path's param values
         */
        var pathMatches = function (target) {
            var state = target.$state();
            var targetParamVals = target.params();
            var targetPath = pathFactory_1.PathFactory.buildPath(target);
            var paramSchema = targetPath.map(function (node) { return node.paramSchema; })
                .reduce(common_1.unnestR, [])
                .filter(function (param) { return targetParamVals.hasOwnProperty(param.id); });
            return function (path) {
                var tailNode = common_1.tail(path);
                if (!tailNode || tailNode.state !== state)
                    return false;
                var paramValues = pathFactory_1.PathFactory.paramValues(path);
                return param_1.Param.equals(paramSchema, paramValues, targetParamVals);
            };
        };
        var isTarget = pathMatches(srefTarget);
        /**
         * Given path: [c, d] appendTo: [a, b]),
         * Expands the path to [c], [c, d]
         * Then appends each to [a,b,] and returns: [a, b, c], [a, b, c, d]
         */
        function spreadToSubPaths(path, appendTo) {
            if (appendTo === void 0) { appendTo = []; }
            return path.map(function (node) { return appendTo.concat(pathFactory_1.PathFactory.subPath(path, node.state)); });
        }
        var tc = $transition$.treeChanges();
        status.active = spreadToSubPaths(tc.from).map(isTarget).reduce(common_1.anyTrueR, false);
        status.exact = isTarget(tc.from);
        status.entering = spreadToSubPaths(tc.entering, tc.retained).map(isTarget).reduce(common_1.anyTrueR, false);
        status.exiting = spreadToSubPaths(tc.exiting, tc.retained).map(isTarget).reduce(common_1.anyTrueR, false);
        if ($transition$.isActive()) {
            this._setStatus(status);
        }
        var update = function (currentPath) { return function () {
            if (_this._deregisterHook == null)
                return; // destroyed
            if (!$transition$.isActive())
                return; // superseded
            status.active = spreadToSubPaths(currentPath).map(isTarget).reduce(common_1.anyTrueR, false);
            status.exact = isTarget(currentPath);
            status.entering = status.exiting = false;
            _this._setStatus(status);
        }; };
        $transition$.promise.then(update(tc.to), update(tc.from));
    };
    __decorate([
        core_1.Output("uiSrefStatus"), 
        __metadata('design:type', Object)
    ], UiSrefStatus.prototype, "uiSrefStatus", void 0);
    UiSrefStatus = __decorate([
        core_1.Directive({ selector: '[uiSrefStatus],[uiSrefActive],[uiSrefActiveEq]' }), 
        __metadata('design:paramtypes', [transitionService_1.TransitionService, globals_1.UIRouterGlobals, stateService_1.StateService, uiSref_1.UiSref])
    ], UiSrefStatus);
    return UiSrefStatus;
}());
exports.UiSrefStatus = UiSrefStatus;
//# sourceMappingURL=uiSrefStatus.js.map