"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
/** @module ng2_directives */ /** */
var core_1 = require('@angular/core');
var core_2 = require("@angular/core");
var core_3 = require("@angular/core");
var router_1 = require("../router");
var trace_1 = require("../common/trace");
var core_4 = require("@angular/core");
var componentUtil_1 = require("./componentUtil");
var viewsBuilder_1 = require("./viewsBuilder");
/** @hidden */
var id = 0;
/**
 * A UI-Router viewport directive, which is filled in by a view (component) on a state.
 *
 * ### Selector
 *
 * A `ui-view` directive can be created as an element: `<ui-view></ui-view>` or as an attribute: `<div ui-view></div>`.
 *
 * ### Purpose
 *
 * This directive is used in a Component template (or as the root component) to create a viewport.  The viewport
 * is filled in by a view (as defined by a [[Ng2ViewDeclaration]] inside a [[Ng2StateDeclaration]]) when the view's
 * state has been activated.
 *
 * @example
 * ```js
 *
 * // This app has two states, 'foo' and 'bar'
 * stateRegistry.register({ name: 'foo', url: '/foo', component: FooComponent });
 * stateRegistry.register({ name: 'bar', url: '/bar', component: BarComponent });
 * ```
 * ```html
 * <!-- This ui-view will be filled in by the foo state's component or
 *      the bar state's component when the foo or bar state is activated -->
 * <ui-view></ui-view>
 * ```
 *
 * ### Named ui-views
 *
 * A `ui-view` may optionally be given a name via the attribute value: `<div ui-view='header'></div>`.  *Note:
 * an unnamed `ui-view` is internally named `$default`*.   When a `ui-view` has a name, it will be filled in
 * by a matching named view.
 *
 * @example
 * ```js
 *
 * stateRegistry.register({
 *   name: 'foo',
 *   url: '/foo',
 *   views: { header: HeaderComponent, $default: FooComponent });
 * ```
 * ```html
 * <!-- When 'foo' state is active, filled by HeaderComponent -->
 * <div ui-view="header"></div>
 *
 * <!-- When 'foo' state is active, filled by FooComponent -->
 * <ui-view></ui-view>
 * ```
 */
var UiView = (function () {
    function UiView(router, parent, compResolver, viewContainerRef) {
        this.router = router;
        this.parent = parent;
        this.compResolver = compResolver;
        this.viewContainerRef = viewContainerRef;
        this.uiViewData = {};
    }
    Object.defineProperty(UiView.prototype, "_name", {
        set: function (val) { this.name = val; },
        enumerable: true,
        configurable: true
    });
    UiView.prototype.ngOnInit = function () {
        var parentFqn = this.parent.fqn;
        var name = this.name || '$default';
        this.uiViewData = {
            $type: 'ng2',
            id: id++,
            name: name,
            fqn: parentFqn ? parentFqn + "." + name : name,
            creationContext: this.parent.context,
            configUpdated: this.viewConfigUpdated.bind(this),
            config: undefined
        };
        this.deregister = this.router.viewService.registerUiView(this.uiViewData);
    };
    UiView.prototype.disposeLast = function () {
        if (this.componentRef)
            this.componentRef.destroy();
        this.componentRef = null;
    };
    UiView.prototype.ngOnDestroy = function () {
        if (this.deregister)
            this.deregister();
        this.disposeLast();
    };
    UiView.prototype.viewConfigUpdated = function (config) {
        var _this = this;
        if (!config)
            return this.disposeLast();
        if (!(config instanceof viewsBuilder_1.Ng2ViewConfig))
            return;
        var uiViewData = this.uiViewData;
        var viewDecl = config.viewDecl;
        // The "new" viewconfig is already applied, so exit early
        if (uiViewData.config === config)
            return;
        // This is a new viewconfig.  Destroy the old component
        this.disposeLast();
        trace_1.trace.traceUiViewConfigUpdated(uiViewData, config && config.viewDecl.$context);
        uiViewData.config = config;
        // The config may be undefined if there is nothing state currently targeting this UiView.
        if (!config)
            return;
        // Map resolves to "useValue providers"
        var rc = config.node.resolveContext;
        var resolvables = rc.getResolvables();
        var rawProviders = Object.keys(resolvables).map(function (key) { return core_2.provide(key, { useValue: resolvables[key].data }); });
        rawProviders.push(core_2.provide(UiView.PARENT_INJECT, { useValue: { context: config.viewDecl.$context, fqn: uiViewData.fqn } }));
        // Get the component class from the view declaration. TODO: allow promises?
        var componentType = viewDecl.component;
        var createComponent = function (factory) {
            var parentInjector = _this.viewContainerRef.injector;
            var childInjector = core_1.ReflectiveInjector.resolveAndCreate(rawProviders, parentInjector);
            var ref = _this.componentRef = _this.viewContainerRef.createComponent(factory, undefined, childInjector);
            // TODO: wire uiCanExit and uiOnParamsChanged callbacks
            // Supply resolve data to matching @Input('prop') or inputs: ['prop']
            var inputs = componentUtil_1.ng2ComponentInputs(componentType);
            var bindings = viewDecl['bindings'] || {};
            inputs.map(function (tuple) { return ({ prop: tuple.prop, resolve: bindings[tuple.prop] || tuple.resolve }); })
                .filter(function (tuple) { return resolvables[tuple.resolve] !== undefined; })
                .forEach(function (tuple) { ref.instance[tuple.prop] = resolvables[tuple.resolve].data; });
        };
        this.compResolver.resolveComponent(componentType).then(createComponent);
    };
    UiView.PARENT_INJECT = "UiView.PARENT_INJECT";
    __decorate([
        core_3.Input('name'), 
        __metadata('design:type', String)
    ], UiView.prototype, "name", void 0);
    __decorate([
        core_3.Input('ui-view'), 
        __metadata('design:type', Object), 
        __metadata('design:paramtypes', [Object])
    ], UiView.prototype, "_name", null);
    UiView = __decorate([
        core_1.Component({
            selector: 'ui-view, [ui-view]',
            template: ''
        }),
        __param(1, core_4.Inject(UiView.PARENT_INJECT)), 
        __metadata('design:paramtypes', [router_1.UIRouter, Object, core_1.ComponentResolver, core_1.ViewContainerRef])
    ], UiView);
    return UiView;
}());
exports.UiView = UiView;
//# sourceMappingURL=uiView.js.map