/** @module ng2 */ /** */
import { State } from "../state/stateObject";
import { Node } from "../path/node";
import { ViewConfig } from "../view/interface";
import { Ng2ViewDeclaration } from "./interface";
/**
 * This is a [[StateBuilder.builder]] function for angular2 `views`.
 *
 * When the [[StateBuilder]] builds a [[State]] object from a raw [[StateDeclaration]], this builder
 * handles the `views` property with logic specific to ui-router-ng2.
 *
 * If no `views: {}` property exists on the [[StateDeclaration]], then it creates the `views` object and
 * applies the state-level configuration to a view named `$default`.
 */
export declare function ng2ViewsBuilder(state: State): {};
export declare class Ng2ViewConfig implements ViewConfig {
    node: Node;
    viewDecl: Ng2ViewDeclaration;
    loaded: boolean;
    constructor(node: Node, viewDecl: Ng2ViewDeclaration);
    load(): any;
}
