"use strict";
var common_1 = require("../common/common");
var coreservices_1 = require("../common/coreservices");
var view_1 = require("../view/view");
/**
 * This is a [[StateBuilder.builder]] function for angular2 `views`.
 *
 * When the [[StateBuilder]] builds a [[State]] object from a raw [[StateDeclaration]], this builder
 * handles the `views` property with logic specific to ui-router-ng2.
 *
 * If no `views: {}` property exists on the [[StateDeclaration]], then it creates the `views` object and
 * applies the state-level configuration to a view named `$default`.
 */
function ng2ViewsBuilder(state) {
    var views = {}, viewsObject = state.views || { "$default": common_1.pick(state, "component") };
    common_1.forEach(viewsObject, function (config, name) {
        name = name || "$default"; // Account for views: { "": { template... } }
        if (Object.keys(config).length == 0)
            return;
        config.$type = "ng2";
        config.$context = state;
        config.$name = name;
        var normalized = view_1.ViewService.normalizeUiViewTarget(config.$context, config.$name);
        config.$uiViewName = normalized.uiViewName;
        config.$uiViewContextAnchor = normalized.uiViewContextAnchor;
        views[name] = config;
    });
    return views;
}
exports.ng2ViewsBuilder = ng2ViewsBuilder;
var Ng2ViewConfig = (function () {
    function Ng2ViewConfig(node, viewDecl) {
        this.node = node;
        this.viewDecl = viewDecl;
        this.loaded = true;
    }
    Ng2ViewConfig.prototype.load = function () {
        return coreservices_1.services.$q.when(this);
    };
    return Ng2ViewConfig;
}());
exports.Ng2ViewConfig = Ng2ViewConfig;
//# sourceMappingURL=viewsBuilder.js.map