/** @module ng2_directives */ /** */
import { UIRouter } from "../../router";
import { ElementRef } from "@angular/core";
import { Renderer } from "@angular/core";
import { ParentUIViewInject } from "./uiView";
import { Obj } from "../../common/common";
import { TransitionOptions } from "../../transition/interface";
import { UIRouterGlobals } from "../../globals";
import { ReplaySubject } from "rxjs/Rx";
import { TargetState } from "../../state/targetState";
/** @hidden */
export declare class AnchorUISref {
    _el: ElementRef;
    _renderer: Renderer;
    constructor(_el: ElementRef, _renderer: Renderer);
    update(href: string): void;
}
/**
 * A directive when clicked, initiates a [[Transition]] to a [[TargetState]].
 *
 * ### Purpose
 *
 * This directive is applied to anchor tags (`<a>`) or any other clickable element.  It is a state reference (or sref --
 * similar to an href).  When clicked, the directive will transition to that state by calling [[StateService.go]],
 * and optionally supply state parameter values and transition options.
 *
 * When this directive is on an anchor tag, it will also add an `href` attribute to the anchor.
 *
 * ### Selector
 *
 * - `[uiSref]`: The directive is created as an attribute on an element, e.g., `<a uiSref></a>`
 *
 * ### Inputs
 *
 * - `uiSref`: the target state's name, e.g., `uiSref="foostate"`.  If a component template uses a relative `uiSref`,
 * e.g., `uiSref=".child"`, the reference is relative to that component's state.
 *
 * - `uiParams`: any target state parameter values, as an object, e.g., `[uiParams]="{ fooId: bar.fooId }"`
 *
 * - `uiOptions`: [[TransitionOptions]], e.g., `[uiOptions]="{ inherit: false }"`
 *
 * @example
 * ```html
 *
 * <!-- Targets bar state' -->
 * <a uiSref="bar">Bar</a>
 *
 * <!-- Assume this component's state is "foo".
 *      Relatively targets "foo.child" -->
 * <a uiSref=".child">Foo Child</a>
 *
 * <!-- Targets "bar" state and supplies parameter value -->
 * <a uiSref="bar" [uiParams]="{ barId: foo.barId }">Bar {{foo.barId}}</a>
 *
 * <!-- Targets "bar" state and parameter, doesn't inherit existing parameters-->
 * <a uiSref="bar" [uiParams]="{ barId: foo.barId }" [uiOptions]="{ inherit: false }">Bar {{foo.barId}}</a>
 * ```
 */
export declare class UISref {
    private _router;
    parent: ParentUIViewInject;
    private _anchorUISref;
    state: string;
    params: any;
    options: any;
    targetState$: ReplaySubject<TargetState>;
    private _emit;
    private _statesSub;
    constructor(_router: UIRouter, parent: ParentUIViewInject, _anchorUISref: AnchorUISref, _globals: UIRouterGlobals);
    "uiSref": string;
    "uiParams": Obj;
    "uiOptions": TransitionOptions;
    ngOnInit(): void;
    ngOnDestroy(): void;
    update(): void;
    getOptions(): any;
    go(): boolean;
}
