"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
/** @module ng2_directives */ /** */
var core_1 = require("@angular/core");
var uiSref_1 = require("./uiSref");
var common_1 = require("../../common/common");
var globals_1 = require("../../globals");
var param_1 = require("../../params/param");
var pathFactory_1 = require("../../path/pathFactory");
var Rx_1 = require("rxjs/Rx");
var inactiveStatus = {
    active: false,
    exact: false,
    entering: false,
    exiting: false
};
/**
 * Returns a Predicate<PathNode[]>
 *
 * The predicate returns true when the target state (and param values)
 * match the (tail of) the path, and the path's param values
 */
var pathMatches = function (target) {
    if (!target.exists())
        return function () { return false; };
    var state = target.$state();
    var targetParamVals = target.params();
    var targetPath = pathFactory_1.PathFactory.buildPath(target);
    var paramSchema = targetPath.map(function (node) { return node.paramSchema; })
        .reduce(common_1.unnestR, [])
        .filter(function (param) { return targetParamVals.hasOwnProperty(param.id); });
    return function (path) {
        var tailNode = common_1.tail(path);
        if (!tailNode || tailNode.state !== state)
            return false;
        var paramValues = pathFactory_1.PathFactory.paramValues(path);
        return param_1.Param.equals(paramSchema, paramValues, targetParamVals);
    };
};
/**
 * Given basePath: [a, b], appendPath: [c, d]),
 * Expands the path to [c], [c, d]
 * Then appends each to [a,b,] and returns: [a, b, c], [a, b, c, d]
 */
function spreadToSubPaths(basePath, appendPath) {
    return appendPath.map(function (node) { return basePath.concat(pathFactory_1.PathFactory.subPath(appendPath, function (n) { return n.state === node.state; })); });
}
/**
 * Given a TransEvt (Transition event: started, success, error)
 * and a UISref Target State, return a SrefStatus object
 * which represents the current status of that Sref:
 * active, activeEq (exact match), entering, exiting
 */
function getSrefStatus(event, srefTarget) {
    var pathMatchesTarget = pathMatches(srefTarget);
    var tc = event.trans.treeChanges();
    var isStartEvent = event.evt === 'start';
    var isSuccessEvent = event.evt === 'success';
    var activePath = isSuccessEvent ? tc.to : tc.from;
    var isActive = function () {
        return spreadToSubPaths([], activePath)
            .map(pathMatchesTarget)
            .reduce(common_1.anyTrueR, false);
    };
    var isExact = function () {
        return pathMatchesTarget(activePath);
    };
    var isEntering = function () {
        return spreadToSubPaths(tc.retained, tc.entering)
            .map(pathMatchesTarget)
            .reduce(common_1.anyTrueR, false);
    };
    var isExiting = function () {
        return spreadToSubPaths(tc.retained, tc.exiting)
            .map(pathMatchesTarget)
            .reduce(common_1.anyTrueR, false);
    };
    return {
        active: isActive(),
        exact: isExact(),
        entering: isStartEvent ? isEntering() : false,
        exiting: isStartEvent ? isExiting() : false,
    };
}
/**
 * A directive (which pairs with a [[UISref]]) and emits events when the UISref status changes.
 *
 * This directive is used by the [[UISrefActive]] directive.
 *
 * The event emitted is of type [[SrefStatus]], and has boolean values for `active`, `exact`, `entering`, and `exiting`
 *
 * The values from this event can be captured and stored on a component, then applied (perhaps using ngClass).
 *
 * This API is subject to change.
 */
var UISrefStatus = (function () {
    function UISrefStatus(_globals) {
        this._globals = _globals;
        /** current statuses of the state/params the uiSref directive is linking to */
        this.uiSrefStatus = new core_1.EventEmitter(false);
        this.status = Object.assign({}, inactiveStatus);
    }
    UISrefStatus.prototype.ngAfterContentInit = function () {
        // Map each transition start event to a stream of:
        // start -> (success|error)
        var transEvents$ = this._globals.start$.switchMap(function (trans) {
            var event = function (evt) { return ({ evt: evt, trans: trans }); };
            var transStart$ = Rx_1.Observable.of(event("start"));
            var transResult = trans.promise.then(function () { return event("success"); }, function () { return event("error"); });
            var transFinish$ = Rx_1.Observable.fromPromise(transResult);
            return transStart$.concat(transFinish$);
        });
        // Watch the children UISref components and get their target states
        var srefs$ = Rx_1.Observable.of(this.srefs.toArray()).concat(this.srefs.changes);
        var targetStates$ = srefs$.switchMap(function (srefs) {
            return Rx_1.Observable.combineLatest(srefs.map(function (sref) { return sref.targetState$; }));
        });
        // Calculate the status of each UISref based on the transition event.
        // Reduce the statuses (if multiple) by or-ing each flag.
        this._subscription = transEvents$.mergeMap(function (evt) {
            return targetStates$.map(function (targets) {
                var statuses = targets.map(function (target) { return getSrefStatus(evt, target); });
                return statuses.reduce(function (acc, val) { return ({
                    active: acc.active || val.active,
                    exact: acc.active || val.active,
                    entering: acc.active || val.active,
                    exiting: acc.active || val.active,
                }); });
            });
        }).subscribe(this._setStatus.bind(this));
    };
    UISrefStatus.prototype.ngOnDestroy = function () {
        if (this._subscription)
            this._subscription.unsubscribe();
    };
    UISrefStatus.prototype._setStatus = function (status) {
        this.status = status;
        this.uiSrefStatus.emit(status);
    };
    __decorate([
        core_1.Output("uiSrefStatus"), 
        __metadata('design:type', Object)
    ], UISrefStatus.prototype, "uiSrefStatus", void 0);
    __decorate([
        core_1.ContentChildren(uiSref_1.UISref, { descendants: true }), 
        __metadata('design:type', core_1.QueryList)
    ], UISrefStatus.prototype, "srefs", void 0);
    UISrefStatus = __decorate([
        core_1.Directive({ selector: '[uiSrefStatus],[uiSrefActive],[uiSrefActiveEq]' }),
        __param(0, core_1.Inject(globals_1.Globals)), 
        __metadata('design:paramtypes', [Object])
    ], UISrefStatus);
    return UISrefStatus;
}());
exports.UISrefStatus = UISrefStatus;
//# sourceMappingURL=uiSrefStatus.js.map