/** @module ng2 */ /** */
import { Transition } from "../transition/transition";
import { LazyLoadResult } from "../state/interface";
/**
 * Returns a function which lazy loads a nested module
 *
 * Use this function as a [[StateDeclaration.lazyLoad]] property to lazy load a state tree (an NgModule).
 *
 * @param path the path to the module source code.
 * @returns A function which takes a transition, then:
 *
 * - Gets the Injector (scoped properly for the destination state)
 * - Loads and creates the NgModule
 * - Finds the "replacement state" for the target state, and adds the new NgModule Injector to it (as a resolve)
 *
 * returns the new states array
 */
export declare function loadNgModule(path: string): (transition: Transition) => Promise<LazyLoadResult>;
