/**
 * # UI-Router for Angular 2
 *
 * For the quick start repository, please see http://github.com/ui-router/quickstart-ng2
 *
 * Getting started:
 *
 * - Use npm. Add a dependency on latest `ui-router-ng2`
 * - Import UI-Router classes directly from `"ui-router-ng2"`
 *
 * ```js
 * import {StateRegistry} from "ui-router-ng2";
 * ```
 *
 * - When defining a component, add the [[UIROUTER_DIRECTIVES]] to `directives:` array.
 * - Either bootstrap a [[UIView]] component, or add a `<ui-view></ui-view>` viewport to your root component.
 * - Create application states (as defined by [[Ng2StateDeclaration]]) which will fill in the viewports.
 * - Create a [[UIRouterConfig]], and register your states in the [[UIRouterConfig.configure]] function.
 *
 * ```js
 * import {UIRouter} from "ui-router-ng2";
 * import {INITIAL_STATES} from "./app.states";
 * @ Injectable()
 * export class MyUIRouterConfig {
 *   configure(uiRouter: UIRouter) {
 *     INITIAL_STATES.forEach(function(state) {
 *       uiRouter.stateRegistry.register(state));
 *     });
 *   }
 * }
 * ```
 *
 * - When bootstrapping: include the [[UIROUTER_PROVIDERS]] and define a provider for your [[UIRouterConfig]]
 *
 * ```js
 * import {provide} from "@angular/core";
 * import {bootstrap} from 'angular2/platform/browser';
 * import {UIRouterConfig, UIView, UIROUTER_PROVIDERS} from "ui-router-ng2";
 * import {MyUIRouterConfig} from "./router.config";
 *
 * bootstrap(UIView, [
 *     ...UIROUTER_PROVIDERS,
 *     provide(UIRouterConfig, { useClass: MyUIRouterConfig })
 * ]);
 * ```
 *
 * @preferred @module ng2
 */ /** */
import { Provider } from "@angular/core";
import { ClassProvider, ExistingProvider, FactoryProvider, TypeProvider, ValueProvider } from "@angular/core";
import { UIRouterConfig } from "./uiRouterConfig";
export declare const _UIROUTER_INSTANCE_PROVIDERS: Provider[];
export declare const _UIROUTER_PROVIDERS: Provider[];
/**
 * Provides an Instance of UI-Router for NG2.
 *
 * Use this on the root NgModule to configure and create an instance of the Angular 2 UIRouter.
 *
 * @example
 * ```js
 *
 * @ UIRouterModule({
 *   states: [ homeState, aboutState ],
 *   providers: [ provideUIRouter({ configClass: MyUIRouterConfig, useHash: true }) ],
 *   bootstrap: [ UIView ]
 * }) class RootNgModule {}
 *
 * platformBrowserDynamic().bootstrapModule(RootNgModule);
 * ```
 *
 * Note: UIRouter should only be provided *once*, on the root module, when bootstrapping the application.
 */
export declare function provideUIRouter(rootConfig?: {
    configClass?: typeof UIRouterConfig;
    useHash?: boolean;
}): (TypeProvider | ValueProvider | ClassProvider | ExistingProvider | FactoryProvider | any[])[];
/**
 * The UI-Router providers, for use in your application bootstrap
 *
 * @deprecated use [[UIRouterModule]] and [[provideUIRouter]]
 */
export declare const UIROUTER_PROVIDERS: Provider[];
