"use strict";
/**
 * # UI-Router for Angular 2
 *
 * For the quick start repository, please see http://github.com/ui-router/quickstart-ng2
 *
 * Getting started:
 *
 * - Use npm. Add a dependency on latest `ui-router-ng2`
 * - Import UI-Router classes directly from `"ui-router-ng2"`
 *
 * ```js
 * import {StateRegistry} from "ui-router-ng2";
 * ```
 *
 * - When defining a component, add the [[UIROUTER_DIRECTIVES]] to `directives:` array.
 * - Either bootstrap a [[UIView]] component, or add a `<ui-view></ui-view>` viewport to your root component.
 * - Create application states (as defined by [[Ng2StateDeclaration]]) which will fill in the viewports.
 * - Create a [[UIRouterConfig]], and register your states in the [[UIRouterConfig.configure]] function.
 *
 * ```js
 * import {UIRouter} from "ui-router-ng2";
 * import {INITIAL_STATES} from "./app.states";
 * @ Injectable()
 * export class MyUIRouterConfig {
 *   configure(uiRouter: UIRouter) {
 *     INITIAL_STATES.forEach(function(state) {
 *       uiRouter.stateRegistry.register(state));
 *     });
 *   }
 * }
 * ```
 *
 * - When bootstrapping: include the [[UIROUTER_PROVIDERS]] and define a provider for your [[UIRouterConfig]]
 *
 * ```js
 * import {provide} from "@angular/core";
 * import {bootstrap} from 'angular2/platform/browser';
 * import {UIRouterConfig, UIView, UIROUTER_PROVIDERS} from "ui-router-ng2";
 * import {MyUIRouterConfig} from "./router.config";
 *
 * bootstrap(UIView, [
 *     ...UIROUTER_PROVIDERS,
 *     provide(UIRouterConfig, { useClass: MyUIRouterConfig })
 * ]);
 * ```
 *
 * @preferred @module ng2
 */ /** */
var core_1 = require("@angular/core");
var router_1 = require("../router");
var stateRegistry_1 = require("../state/stateRegistry");
var stateService_1 = require("../state/stateService");
var transitionService_1 = require("../transition/transitionService");
var urlMatcherFactory_1 = require("../url/urlMatcherFactory");
var urlRouter_1 = require("../url/urlRouter");
var view_1 = require("../view/view");
var uiView_1 = require("./directives/uiView");
var views_1 = require("./statebuilders/views");
var interface_1 = require("./interface");
var uiRouterConfig_1 = require("./uiRouterConfig");
var globals_1 = require("../globals");
var location_1 = require("./location");
var coreservices_1 = require("../common/coreservices");
var resolvable_1 = require("../resolve/resolvable");
var lazyLoadNgModuleResolvable_1 = require("./statebuilders/lazyLoadNgModuleResolvable");
var common_1 = require("../common/common");
var uiRouterNgModule_1 = require("./uiRouterNgModule");
var rx_1 = require("./rx");
var common_2 = require("@angular/common");
/**
 * This is a factory function for a UIRouter instance
 *
 * Creates a UIRouter instance and configures it for Angular 2, then invokes router bootstrap.
 * This function is used as an Angular 2 `useFactory` Provider.
 */
var uiRouterFactory = function (routerConfig, location, injector) {
    // ----------------- Monkey Patches ----------------
    // Monkey patch the services.$injector to the ng2 Injector
    coreservices_1.services.$injector.get = injector.get.bind(injector);
    // Monkey patch the services.$location with ng2 Location implementation
    location.init();
    // ----------------- Create router -----------------
    // Create a new ng2 UIRouter and configure it for ng2
    var router = new router_1.UIRouter();
    new rx_1.UIRouterRx(router);
    var registry = router.stateRegistry;
    // ----------------- Configure for ng2 -------------
    // Apply ng2 ui-view handling code
    router.viewService.viewConfigFactory("ng2", function (path, config) { return new views_1.Ng2ViewConfig(path, config); });
    registry.decorator('views', views_1.ng2ViewsBuilder);
    // Apply statebuilder decorator for ng2 NgModule registration
    registry.stateQueue.flush(router.stateService);
    registry.decorator('resolvables', lazyLoadNgModuleResolvable_1.ngModuleResolvablesBuilder);
    // Prep the tree of NgModule by placing the root NgModule's Injector on the root state.
    var ng2InjectorResolvable = resolvable_1.Resolvable.fromData(interface_1.NG2_INJECTOR_TOKEN, injector);
    registry.root().resolvables.push(ng2InjectorResolvable);
    // ----------------- Initialize router -------------
    // Allow states to be registered
    registry.stateQueue.autoFlush(router.stateService);
    setTimeout(function () {
        // Let the app apply custom configuration...
        // (global transition hooks, deferIntercept, otherwise, etc)
        routerConfig.configure(router);
        // Register the states from the root NgModule [[UIRouterModule]]
        var states = injector.get(uiRouterNgModule_1.UIROUTER_STATES_TOKEN, []).reduce(common_1.flattenR, []);
        states.forEach(function (state) { return registry.register(state); });
        // Start monitoring the URL
        if (!router.urlRouterProvider.interceptDeferred) {
            router.urlRouter.listen();
            router.urlRouter.sync();
        }
    });
    return router;
};
exports._UIROUTER_INSTANCE_PROVIDERS = [
    { provide: router_1.UIRouter, useFactory: uiRouterFactory, deps: [uiRouterConfig_1.UIRouterConfig, location_1.UIRouterLocation, core_1.Injector] },
    { provide: location_1.UIRouterLocation, useClass: location_1.UIRouterLocation },
];
exports._UIROUTER_PROVIDERS = [
    { provide: stateService_1.StateService, useFactory: function (r) { return r.stateService; }, deps: [router_1.UIRouter] },
    { provide: transitionService_1.TransitionService, useFactory: function (r) { return r.transitionService; }, deps: [router_1.UIRouter] },
    { provide: urlMatcherFactory_1.UrlMatcherFactory, useFactory: function (r) { return r.urlMatcherFactory; }, deps: [router_1.UIRouter] },
    { provide: urlRouter_1.UrlRouter, useFactory: function (r) { return r.urlRouter; }, deps: [router_1.UIRouter] },
    { provide: view_1.ViewService, useFactory: function (r) { return r.viewService; }, deps: [router_1.UIRouter] },
    { provide: stateRegistry_1.StateRegistry, useFactory: function (r) { return r.stateRegistry; }, deps: [router_1.UIRouter] },
    { provide: globals_1.Globals, useFactory: function (r) { return r.globals; }, deps: [router_1.UIRouter] },
    { provide: uiView_1.UIView.PARENT_INJECT, useFactory: function (r) { return { fqn: null, context: r.root() }; }, deps: [stateRegistry_1.StateRegistry] }
];
/**
 * Provides an Instance of UI-Router for NG2.
 *
 * Use this on the root NgModule to configure and create an instance of the Angular 2 UIRouter.
 *
 * @example
 * ```js
 *
 * @ UIRouterModule({
 *   states: [ homeState, aboutState ],
 *   providers: [ provideUIRouter({ configClass: MyUIRouterConfig, useHash: true }) ],
 *   bootstrap: [ UIView ]
 * }) class RootNgModule {}
 *
 * platformBrowserDynamic().bootstrapModule(RootNgModule);
 * ```
 *
 * Note: UIRouter should only be provided *once*, on the root module, when bootstrapping the application.
 */
function provideUIRouter(rootConfig) {
    if (rootConfig === void 0) { rootConfig = {}; }
    // Provide the UIRouter instance providers
    return exports._UIROUTER_INSTANCE_PROVIDERS.concat(
    // Provide the user-supplied UIRouterConfig class, or use base UIRouterConfig (as a no-op config)
    { provide: uiRouterConfig_1.UIRouterConfig, useClass: (rootConfig.configClass || uiRouterConfig_1.UIRouterConfig) }, 
    // Provide the PathLocationStrategy by default unless `useHash` is `true`
    { provide: common_2.LocationStrategy, useClass: (rootConfig.useHash ? common_2.HashLocationStrategy : common_2.PathLocationStrategy) });
}
exports.provideUIRouter = provideUIRouter;
/**
 * The UI-Router providers, for use in your application bootstrap
 *
 * @deprecated use [[UIRouterModule]] and [[provideUIRouter]]
 */
exports.UIROUTER_PROVIDERS = exports._UIROUTER_INSTANCE_PROVIDERS.concat(exports._UIROUTER_PROVIDERS);
//# sourceMappingURL=providers.js.map