"use strict";
var interface_1 = require("../interface");
var resolvable_1 = require("../../resolve/resolvable");
/**
 * This is a [[StateBuilder.builder]] function which enables lazy Ng2Module support.
 *
 * See [[loadNgModule]]
 *
 * After lazy loading an NgModule, any Components from that module should be created using the NgModule's Injecjtor.
 * The NgModule's ComponentFactory only exists inside that Injector.
 *
 * After lazy loading an NgModule, it is stored on the root state of the lazy loaded state tree.
 * When instantiating Component, the parent Component's Injector is merged with the NgModule injector.
 */
function ngModuleResolvablesBuilder(state, parentFn) {
    var resolvables = parentFn(state);
    var injector = state.self['_ngModuleInjector'];
    return !injector ? resolvables : resolvables.concat(resolvable_1.Resolvable.fromData(interface_1.NG2_INJECTOR_TOKEN, injector));
}
exports.ngModuleResolvablesBuilder = ngModuleResolvablesBuilder;
//# sourceMappingURL=lazyLoadNgModuleResolvable.js.map