"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require("@angular/core");
var directives_1 = require("./directives/directives");
var providers_1 = require("./providers");
var uiView_1 = require("./directives/uiView");
var common_1 = require("../common/common");
var UIRouterLibraryModule = (function () {
    function UIRouterLibraryModule() {
    }
    UIRouterLibraryModule = __decorate([
        core_1.NgModule({
            declarations: [directives_1._UIROUTER_DIRECTIVES],
            exports: [directives_1._UIROUTER_DIRECTIVES],
            entryComponents: [uiView_1.UIView],
            providers: [providers_1._UIROUTER_PROVIDERS]
        }), 
        __metadata('design:paramtypes', [])
    ], UIRouterLibraryModule);
    return UIRouterLibraryModule;
}());
exports.UIRouterLibraryModule = UIRouterLibraryModule;
exports.UIROUTER_STATES_TOKEN = new core_1.OpaqueToken("UIRouter States");
/**
 * Declares a NgModule with UI-Router states
 *
 * A Typescript decorator for declaring an [NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
 * which contains UI-Router states and/or uses UI-Router directives and providers.
 *
 * The decorator adds the `UIRouterLibraryModule` NgModule as an import.
 * The `UIRouterLibraryModule has the UI-Router directives and providers.
 *
 * The decorator also analyzes the `states:` property.
 * When it finds a state with a routed `component:`, it adds the component
 * to the module's `declarations` and `entryComponents`.
 *
 * Note: adding the component to `entryComponents` instructs the Module Compiler that those
 * components should be compiled.
 * Otherwise, they would not be automatically discovered as "reachable" by the compiler.
 *
 * Further, the states found in the `states:` property are added to Dependency Injection
 * using a specific token.
 * This will automatically register them with the [[StateRegistry]] when the application bootstraps.
 *
 * @example
 * ```js
 *
 * var homeState = { name: 'home', url: '/home', component: Home };
 * var aboutState = { name: 'about', url: '/about', component: About };
 *
 * @ UIRouterModule({
 *   imports: [ BrowserModule ],
 *   declarations: [ NonRoutedComponent ],
 *   states: [ homeState, aboutState ]
 * }) export class AppModule {};
 * ```
 *
 * ---
 *
 * Note: the `UIRouterModule` decorator creates a standard Angular 2 `NgModule`.
 * The equivalent `AppModule` could also be crafted by hand using only the `NgModule` decorator:
 *
 * ```js
 * var homeState = { name: 'home', url: '/home', component: Home };
 * var aboutState = { name: 'about', url: '/about', component: About };
 *
 * @ NgModule({
 *   imports: [BrowserModule, UIRouterLibraryModule],
 *   declarations: [NonRoutedComponent, Home, About],
 *   entryComponents: [Home, About],
 *   providers: [
 *    { provide: UIROUTER_STATES_TOKEN, useValue: [homeState, aboutState], multi: true }
 *   ]
 * }) export class AppModule {};
 * ```
 *
 * @param moduleMetaData
 *        (See also [NgModuleMetadataType](https://angular.io/docs/ts/latest/api/core/index/NgModuleMetadataType-interface.html)
 */
function UIRouterModule(moduleMetaData) {
    var states = moduleMetaData.states || [];
    var statesProvider = { provide: exports.UIROUTER_STATES_TOKEN, useValue: states, multi: true };
    // Get the component classes for all views for all states in the module
    var routedComponents = states.reduce(common_1.flattenR, [])
        .map(function (state) { return state.views || { $default: state }; })
        .map(function (viewObj) { return Object.keys(viewObj).map(function (key) { return viewObj[key].component; }); })
        .reduce(function (acc, arr) { return acc.concat(arr); }, [])
        .filter(function (x) { return typeof x === 'function' && x !== uiView_1.UIView; });
    moduleMetaData.imports = (moduleMetaData.imports || []).concat(UIRouterLibraryModule).reduce(common_1.uniqR, []);
    moduleMetaData.declarations = (moduleMetaData.declarations || []).concat(routedComponents).reduce(common_1.uniqR, []);
    moduleMetaData.entryComponents = (moduleMetaData.entryComponents || []).concat(routedComponents).reduce(common_1.uniqR, []);
    moduleMetaData.providers = (moduleMetaData.providers || []).concat(statesProvider);
    return function (moduleClass) {
        return core_1.NgModule(moduleMetaData)(moduleClass);
    };
}
exports.UIRouterModule = UIRouterModule;
//# sourceMappingURL=uiRouterNgModule.js.map