/** @module ng2_directives */ /** */
import { ElementRef, Renderer } from "@angular/core";
import { UISrefStatus } from "./uiSrefStatus";
/**
 * A directive that adds a CSS class when a `uiSref` is active.
 *
 * ### Purpose
 *
 * This directive should be paired with a [[UISref]], and is used to apply a CSS class to the element when
 * the state that the `uiSref` targets is active.
 *
 * ### Selectors
 *
 * - `[uiSrefActive]`: When this selector is used, the class is added when the target state or any
 * child of the target state is active
 * - `[uiSrefActiveEq]`: When this selector is used, the class is added when the target state is directly active
 *
 * ### Inputs
 *
 * - `uiSrefActive`/`uiSrefActiveEq`: one or more CSS classes to add to the element, when active
 *
 * @example
 * ```html
 *
 * <a uiSref="foo" uiSrefActive="active">Foo</a>
 * <a uiSref="foo.bar" [uiParams]="{ id: bar.id }" uiSrefActive="active">Foo Bar #{{bar.id}}</a>
 * ```
 */
export declare class UISrefActive {
    private _classes;
    active: string;
    private _classesEq;
    activeEq: string;
    private _subscription;
    constructor(uiSrefStatus: UISrefStatus, rnd: Renderer, host: ElementRef);
    ngOnDestroy(): void;
}
