/** @module ng2_directives */ /** */
import { EventEmitter, QueryList } from "@angular/core";
import { UISref } from "./uiSref";
import { UIRouterGlobals } from "../../globals";
/**
 * uiSref status booleans
 */
export interface SrefStatus {
    /** The sref's target state (or one of its children) is currently active */
    active: boolean;
    /** The sref's target state is currently active */
    exact: boolean;
    /** A transition is entering the sref's target state */
    entering: boolean;
    /** A transition is exiting the sref's target state */
    exiting: boolean;
}
/**
 * A directive (which pairs with a [[UISref]]) and emits events when the UISref status changes.
 *
 * This directive is used by the [[UISrefActive]] directive.
 *
 * The event emitted is of type [[SrefStatus]], and has boolean values for `active`, `exact`, `entering`, and `exiting`
 *
 * The values from this event can be captured and stored on a component, then applied (perhaps using ngClass).
 *
 * This API is subject to change.
 */
export declare class UISrefStatus {
    private _globals;
    /** current statuses of the state/params the uiSref directive is linking to */
    uiSrefStatus: EventEmitter<SrefStatus>;
    /** Monitor all child components for UISref(s) */
    srefs: QueryList<UISref>;
    /** The current status */
    status: SrefStatus;
    private _subscription;
    constructor(_globals: UIRouterGlobals);
    ngAfterContentInit(): void;
    ngOnDestroy(): void;
    private _setStatus(status);
}
