/** @module ng2 */ /** */
import { Observable } from "rxjs/Rx";
import { Transition } from "../transition/transition";
import { UIRouter } from "../router";
import { StateDeclaration } from "../state/interface";
export interface StatesChangedEvent {
    currentStates: StateDeclaration[];
    registered: StateDeclaration[];
    deregistered: StateDeclaration[];
}
declare module '../globals' {
    interface UIRouterGlobals {
        states$?: Observable<StatesChangedEvent>;
        start$?: Observable<Transition>;
        success$?: Observable<Transition>;
        params$?: Observable<{
            [paramName: string]: any;
        }>;
    }
}
/** Augments UIRouterGlobals with observables for transition starts, successful transitions, and state parameters */
export declare class UIRouterRx {
    private deregisterFns;
    constructor(router: UIRouter);
    dispose(): void;
}
