var KeyCodes;
(function (KeyCodes) {
    KeyCodes[KeyCodes["BACKSPACE"] = 8] = "BACKSPACE";
    KeyCodes[KeyCodes["TAB"] = 9] = "TAB";
    KeyCodes[KeyCodes["ENTER"] = 13] = "ENTER";
    KeyCodes[KeyCodes["SHIFT"] = 16] = "SHIFT";
    KeyCodes[KeyCodes["CONTROL"] = 17] = "CONTROL";
    KeyCodes[KeyCodes["ALT"] = 18] = "ALT";
    KeyCodes[KeyCodes["BREAK"] = 19] = "BREAK";
    KeyCodes[KeyCodes["CAPS_LOCK"] = 20] = "CAPS_LOCK";
    KeyCodes[KeyCodes["ESCAPE"] = 27] = "ESCAPE";
    KeyCodes[KeyCodes["SPACE"] = 32] = "SPACE";
    KeyCodes[KeyCodes["PAGE_UP"] = 33] = "PAGE_UP";
    KeyCodes[KeyCodes["PAGE_DOWN"] = 34] = "PAGE_DOWN";
    KeyCodes[KeyCodes["END"] = 35] = "END";
    KeyCodes[KeyCodes["HOME"] = 36] = "HOME";
    KeyCodes[KeyCodes["ARROW_LEFT"] = 37] = "ARROW_LEFT";
    KeyCodes[KeyCodes["ARROW_UP"] = 38] = "ARROW_UP";
    KeyCodes[KeyCodes["ARROW_RIGHT"] = 39] = "ARROW_RIGHT";
    KeyCodes[KeyCodes["ARROW_DOWN"] = 40] = "ARROW_DOWN";
    KeyCodes[KeyCodes["PRINT"] = 44] = "PRINT";
    KeyCodes[KeyCodes["INSERT"] = 45] = "INSERT";
    KeyCodes[KeyCodes["DELETE"] = 46] = "DELETE";
    KeyCodes[KeyCodes["DIGIT_0"] = 48] = "DIGIT_0";
    KeyCodes[KeyCodes["DIGIT_1"] = 49] = "DIGIT_1";
    KeyCodes[KeyCodes["DIGIT_2"] = 50] = "DIGIT_2";
    KeyCodes[KeyCodes["DIGIT_3"] = 51] = "DIGIT_3";
    KeyCodes[KeyCodes["DIGIT_4"] = 52] = "DIGIT_4";
    KeyCodes[KeyCodes["DIGIT_5"] = 53] = "DIGIT_5";
    KeyCodes[KeyCodes["DIGIT_6"] = 54] = "DIGIT_6";
    KeyCodes[KeyCodes["DIGIT_7"] = 55] = "DIGIT_7";
    KeyCodes[KeyCodes["DIGIT_8"] = 56] = "DIGIT_8";
    KeyCodes[KeyCodes["DIGIT_9"] = 57] = "DIGIT_9";
    KeyCodes[KeyCodes["A"] = 65] = "A";
    KeyCodes[KeyCodes["B"] = 66] = "B";
    KeyCodes[KeyCodes["C"] = 67] = "C";
    KeyCodes[KeyCodes["D"] = 68] = "D";
    KeyCodes[KeyCodes["E"] = 69] = "E";
    KeyCodes[KeyCodes["F"] = 70] = "F";
    KeyCodes[KeyCodes["G"] = 71] = "G";
    KeyCodes[KeyCodes["H"] = 72] = "H";
    KeyCodes[KeyCodes["I"] = 73] = "I";
    KeyCodes[KeyCodes["J"] = 74] = "J";
    KeyCodes[KeyCodes["K"] = 75] = "K";
    KeyCodes[KeyCodes["L"] = 76] = "L";
    KeyCodes[KeyCodes["M"] = 77] = "M";
    KeyCodes[KeyCodes["N"] = 78] = "N";
    KeyCodes[KeyCodes["O"] = 79] = "O";
    KeyCodes[KeyCodes["P"] = 80] = "P";
    KeyCodes[KeyCodes["Q"] = 81] = "Q";
    KeyCodes[KeyCodes["R"] = 82] = "R";
    KeyCodes[KeyCodes["S"] = 83] = "S";
    KeyCodes[KeyCodes["T"] = 84] = "T";
    KeyCodes[KeyCodes["U"] = 85] = "U";
    KeyCodes[KeyCodes["V"] = 86] = "V";
    KeyCodes[KeyCodes["W"] = 87] = "W";
    KeyCodes[KeyCodes["X"] = 88] = "X";
    KeyCodes[KeyCodes["Y"] = 89] = "Y";
    KeyCodes[KeyCodes["Z"] = 90] = "Z";
    KeyCodes[KeyCodes["WINDOWS"] = 91] = "WINDOWS";
    KeyCodes[KeyCodes["CONTEXT_MENU"] = 93] = "CONTEXT_MENU";
    KeyCodes[KeyCodes["TURN_OFF"] = 94] = "TURN_OFF";
    KeyCodes[KeyCodes["SLEEP"] = 95] = "SLEEP";
    KeyCodes[KeyCodes["NUMPAD_0"] = 96] = "NUMPAD_0";
    KeyCodes[KeyCodes["NUMPAD_1"] = 97] = "NUMPAD_1";
    KeyCodes[KeyCodes["NUMPAD_2"] = 98] = "NUMPAD_2";
    KeyCodes[KeyCodes["NUMPAD_3"] = 99] = "NUMPAD_3";
    KeyCodes[KeyCodes["NUMPAD_4"] = 100] = "NUMPAD_4";
    KeyCodes[KeyCodes["NUMPAD_5"] = 101] = "NUMPAD_5";
    KeyCodes[KeyCodes["NUMPAD_6"] = 102] = "NUMPAD_6";
    KeyCodes[KeyCodes["NUMPAD_7"] = 103] = "NUMPAD_7";
    KeyCodes[KeyCodes["NUMPAD_8"] = 104] = "NUMPAD_8";
    KeyCodes[KeyCodes["NUMPAD_9"] = 105] = "NUMPAD_9";
    KeyCodes[KeyCodes["NUMPAD_ASTERISK"] = 106] = "NUMPAD_ASTERISK";
    KeyCodes[KeyCodes["NUMPAD_PLUS"] = 107] = "NUMPAD_PLUS";
    KeyCodes[KeyCodes["NUMPAD_MINUS"] = 109] = "NUMPAD_MINUS";
    KeyCodes[KeyCodes["NUMPAD_COMMA"] = 110] = "NUMPAD_COMMA";
    KeyCodes[KeyCodes["NUMPAD_SLASH"] = 111] = "NUMPAD_SLASH";
    KeyCodes[KeyCodes["F1"] = 112] = "F1";
    KeyCodes[KeyCodes["F2"] = 113] = "F2";
    KeyCodes[KeyCodes["F3"] = 114] = "F3";
    KeyCodes[KeyCodes["F4"] = 115] = "F4";
    KeyCodes[KeyCodes["F5"] = 116] = "F5";
    KeyCodes[KeyCodes["F6"] = 117] = "F6";
    KeyCodes[KeyCodes["F7"] = 118] = "F7";
    KeyCodes[KeyCodes["F8"] = 119] = "F8";
    KeyCodes[KeyCodes["F9"] = 120] = "F9";
    KeyCodes[KeyCodes["F10"] = 121] = "F10";
    KeyCodes[KeyCodes["F11"] = 122] = "F11";
    KeyCodes[KeyCodes["F12"] = 123] = "F12";
    KeyCodes[KeyCodes["NUM_LOCK"] = 144] = "NUM_LOCK";
    KeyCodes[KeyCodes["SCROLL_LOCK"] = 145] = "SCROLL_LOCK";
    KeyCodes[KeyCodes["OPEN_BRACKET"] = 186] = "OPEN_BRACKET";
    KeyCodes[KeyCodes["PLUS"] = 187] = "PLUS";
    KeyCodes[KeyCodes["COMMA"] = 188] = "COMMA";
    KeyCodes[KeyCodes["SLASH"] = 189] = "SLASH";
    KeyCodes[KeyCodes["DOT"] = 190] = "DOT";
    KeyCodes[KeyCodes["PIPE"] = 191] = "PIPE";
    KeyCodes[KeyCodes["SEMICOLON"] = 192] = "SEMICOLON";
    KeyCodes[KeyCodes["MINUS"] = 219] = "MINUS";
    KeyCodes[KeyCodes["GREAT_ACCENT"] = 220] = "GREAT_ACCENT";
    KeyCodes[KeyCodes["EQUALS"] = 221] = "EQUALS";
    KeyCodes[KeyCodes["SINGLE_QUOTE"] = 222] = "SINGLE_QUOTE";
    KeyCodes[KeyCodes["BACKSLASH"] = 226] = "BACKSLASH";
})(KeyCodes || (KeyCodes = {}));
const isEnter = (event) => (event.key ? event.key === "Enter" : event.keyCode === KeyCodes.ENTER) && !hasModifierKeys(event);
const isEnterShift = (event) => (event.key ? event.key === "Enter" : event.keyCode === KeyCodes.ENTER) && checkModifierKeys(event, false, false, true);
const isSpace = (event) => (event.key ? (event.key === "Spacebar" || event.key === " ") : event.keyCode === KeyCodes.SPACE) && !hasModifierKeys(event);
const isSpaceShift = (event) => (event.key ? (event.key === "Spacebar" || event.key === " ") : event.keyCode === KeyCodes.SPACE) && checkModifierKeys(event, false, false, true);
const isSpaceCtrl = (event) => (event.key ? (event.key === "Spacebar" || event.key === " ") : event.keyCode === KeyCodes.SPACE) && checkModifierKeys(event, true, false, false);
const isLeft = (event) => (event.key ? (event.key === "ArrowLeft" || event.key === "Left") : event.keyCode === KeyCodes.ARROW_LEFT) && !hasModifierKeys(event);
const isRight = (event) => (event.key ? (event.key === "ArrowRight" || event.key === "Right") : event.keyCode === KeyCodes.ARROW_RIGHT) && !hasModifierKeys(event);
const isUp = (event) => (event.key ? (event.key === "ArrowUp" || event.key === "Up") : event.keyCode === KeyCodes.ARROW_UP) && !hasModifierKeys(event);
const isDown = (event) => (event.key ? (event.key === "ArrowDown" || event.key === "Down") : event.keyCode === KeyCodes.ARROW_DOWN) && !hasModifierKeys(event);
const isLeftCtrl = (event) => (event.key ? (event.key === "ArrowLeft" || event.key === "Left") : event.keyCode === KeyCodes.ARROW_LEFT) && checkModifierKeys(event, true, false, false);
const isRightCtrl = (event) => (event.key ? (event.key === "ArrowRight" || event.key === "Right") : event.keyCode === KeyCodes.ARROW_RIGHT) && checkModifierKeys(event, true, false, false);
const isUpCtrl = (event) => (event.key ? (event.key === "ArrowUp" || event.key === "Up") : event.keyCode === KeyCodes.ARROW_UP) && checkModifierKeys(event, true, false, false);
const isDownCtrl = (event) => (event.key ? (event.key === "ArrowDown" || event.key === "Down") : event.keyCode === KeyCodes.ARROW_DOWN) && checkModifierKeys(event, true, false, false);
const isUpShift = (event) => (event.key ? (event.key === "ArrowUp" || event.key === "Up") : event.keyCode === KeyCodes.ARROW_UP) && checkModifierKeys(event, false, false, true);
const isDownShift = (event) => (event.key ? (event.key === "ArrowDown" || event.key === "Down") : event.keyCode === KeyCodes.ARROW_DOWN) && checkModifierKeys(event, false, false, true);
const isUpAlt = (event) => (event.key ? (event.key === "ArrowUp" || event.key === "Up") : event.keyCode === KeyCodes.ARROW_UP) && checkModifierKeys(event, false, true, false);
const isDownAlt = (event) => (event.key ? (event.key === "ArrowDown" || event.key === "Down") : event.keyCode === KeyCodes.ARROW_DOWN) && checkModifierKeys(event, false, true, false);
const isLeftShift = (event) => (event.key ? (event.key === "ArrowLeft" || event.key === "Left") : event.keyCode === KeyCodes.ARROW_LEFT) && checkModifierKeys(event, false, false, true);
const isRightShift = (event) => (event.key ? (event.key === "ArrowRight" || event.key === "Right") : event.keyCode === KeyCodes.ARROW_RIGHT) && checkModifierKeys(event, false, false, true);
const isLeftShiftCtrl = (event) => (event.key ? (event.key === "ArrowLeft" || event.key === "Left") : event.keyCode === KeyCodes.ARROW_LEFT) && checkModifierKeys(event, true, false, true);
const isRightShiftCtrl = (event) => (event.key ? (event.key === "ArrowRight" || event.key === "Right") : event.keyCode === KeyCodes.ARROW_RIGHT) && checkModifierKeys(event, true, false, true);
const isUpShiftCtrl = (event) => (event.key ? (event.key === "ArrowUp" || event.key === "Up") : event.keyCode === KeyCodes.ARROW_UP) && checkModifierKeys(event, true, false, true);
const isDownShiftCtrl = (event) => (event.key ? (event.key === "ArrowDown" || event.key === "Down") : event.keyCode === KeyCodes.ARROW_DOWN) && checkModifierKeys(event, true, false, true);
const isHome = (event) => (event.key ? event.key === "Home" : event.keyCode === KeyCodes.HOME) && !hasModifierKeys(event);
const isEnd = (event) => (event.key ? event.key === "End" : event.keyCode === KeyCodes.END) && !hasModifierKeys(event);
const isHomeCtrl = (event) => (event.key ? event.key === "Home" : event.keyCode === KeyCodes.HOME) && checkModifierKeys(event, true, false, false);
const isHomeShift = (event) => (event.key ? event.key === "Home" : event.keyCode === KeyCodes.HOME) && checkModifierKeys(event, false, false, true);
const isEndCtrl = (event) => (event.key ? event.key === "End" : event.keyCode === KeyCodes.END) && checkModifierKeys(event, true, false, false);
const isEndShift = (event) => (event.key ? event.key === "End" : event.keyCode === KeyCodes.END) && checkModifierKeys(event, false, false, true);
const isEscape = (event) => (event.key ? event.key === "Escape" || event.key === "Esc" : event.keyCode === KeyCodes.ESCAPE) && !hasModifierKeys(event);
const isTabNext = (event) => (event.key ? event.key === "Tab" : event.keyCode === KeyCodes.TAB) && !hasModifierKeys(event);
const isTabPrevious = (event) => (event.key ? event.key === "Tab" : event.keyCode === KeyCodes.TAB) && checkModifierKeys(event, /* Ctrl */ false, /* Alt */ false, /* Shift */ true);
const isBackSpace = (event) => (event.key ? event.key === "Backspace" : event.keyCode === KeyCodes.BACKSPACE) && !hasModifierKeys(event);
const isDelete = (event) => (event.key ? event.key === "Delete" : event.keyCode === KeyCodes.DELETE) && !hasModifierKeys(event);
const isDeleteShift = (event) => (event.key ? event.key === "Delete" : event.keyCode === KeyCodes.DELETE) && checkModifierKeys(event, false, false, true);
const isInsertShift = (event) => (event.key ? event.key === "Insert" : event.keyCode === KeyCodes.DELETE) && checkModifierKeys(event, false, false, true);
const isInsertCtrl = (event) => (event.key ? event.key === "Insert" : event.keyCode === KeyCodes.DELETE) && checkModifierKeys(event, true, false, false);
const isPageUp = (event) => (event.key ? event.key === "PageUp" : event.keyCode === KeyCodes.PAGE_UP) && !hasModifierKeys(event);
const isPageDown = (event) => (event.key ? event.key === "PageDown" : event.keyCode === KeyCodes.PAGE_DOWN) && !hasModifierKeys(event);
const isPageUpShift = (event) => (event.key ? event.key === "PageUp" : event.keyCode === KeyCodes.PAGE_UP) && checkModifierKeys(event, false, false, true);
const isPageUpAlt = (event) => (event.key ? event.key === "PageUp" : event.keyCode === KeyCodes.PAGE_UP) && checkModifierKeys(event, false, true, false);
const isPageDownShift = (event) => (event.key ? event.key === "PageDown" : event.keyCode === KeyCodes.PAGE_DOWN) && checkModifierKeys(event, false, false, true);
const isPageDownAlt = (event) => (event.key ? event.key === "PageDown" : event.keyCode === KeyCodes.PAGE_DOWN) && checkModifierKeys(event, false, true, false);
const isPageUpShiftCtrl = (event) => (event.key ? event.key === "PageUp" : event.keyCode === KeyCodes.PAGE_UP) && checkModifierKeys(event, true, false, true);
const isPageDownShiftCtrl = (event) => (event.key ? event.key === "PageDown" : event.keyCode === KeyCodes.PAGE_DOWN) && checkModifierKeys(event, true, false, true);
const isPlus = (event) => (event.key ? event.key === "+" : event.keyCode === KeyCodes.PLUS) || (event.keyCode === KeyCodes.NUMPAD_PLUS && !hasModifierKeys(event));
const isMinus = (event) => (event.key ? event.key === "-" : event.keyCode === KeyCodes.MINUS) || (event.keyCode === KeyCodes.NUMPAD_MINUS && !hasModifierKeys(event));
const isShow = (event) => {
    if (event.key) {
        return isF4(event) || isShowByArrows(event);
    }
    return (event.keyCode === KeyCodes.F4 && !hasModifierKeys(event)) || (event.keyCode === KeyCodes.ARROW_DOWN && checkModifierKeys(event, /* Ctrl */ false, /* Alt */ true, /* Shift */ false));
};
const isF4 = (event) => {
    return event.key === "F4" && !hasModifierKeys(event);
};
const isF4Shift = (event) => (event.key ? event.key === "F4" : event.keyCode === KeyCodes.F4) && checkModifierKeys(event, false, false, true);
const isF6Next = (event) => ((event.key ? event.key === "F6" : event.keyCode === KeyCodes.F6) && checkModifierKeys(event, false, false, false))
    || ((event.key ? (event.key === "ArrowDown" || event.key === "Down") : event.keyCode === KeyCodes.ARROW_DOWN) && checkModifierKeys(event, true, true, false));
const isF6Previous = (event) => ((event.key ? event.key === "F6" : event.keyCode === KeyCodes.F6) && checkModifierKeys(event, false, false, true))
    || ((event.key ? (event.key === "ArrowUp" || event.key === "Up") : event.keyCode === KeyCodes.ARROW_UP) && checkModifierKeys(event, true, true, false));
const isF7 = (event) => (event.key ? event.key === "F7" : event.keyCode === KeyCodes.F7) && !hasModifierKeys(event);
const isShowByArrows = (event) => {
    return ((event.key === "ArrowDown" || event.key === "Down") || (event.key === "ArrowUp" || event.key === "Up")) && checkModifierKeys(event, /* Ctrl */ false, /* Alt */ true, /* Shift */ false);
};
const isShift = (event) => event.key === "Shift" || event.keyCode === KeyCodes.SHIFT;
const isCtrlA = (event) => ((event.key === "A" || event.key === "a") || event.which === KeyCodes.A) && checkModifierKeys(event, true, false, false);
const isCtrlV = (event) => ((event.key === "V" || event.key === "v") || event.which === KeyCodes.V) && checkModifierKeys(event, true, false, false);
const hasModifierKeys = (event) => event.shiftKey || event.altKey || getCtrlKey(event);
const getCtrlKey = (event) => !!(event.metaKey || event.ctrlKey); // double negation doesn't have effect on boolean but ensures null and undefined are equivalent to false.
const checkModifierKeys = (event, bCtrlKey, bAltKey, bShiftKey) => event.shiftKey === bShiftKey && event.altKey === bAltKey && getCtrlKey(event) === bCtrlKey;
export { isEnter, isEnterShift, isSpace, isSpaceShift, isSpaceCtrl, isLeft, isRight, isUp, isDown, isLeftCtrl, isRightCtrl, isUpCtrl, isDownCtrl, isUpShift, isDownShift, isUpAlt, isDownAlt, isLeftShift, isRightShift, isLeftShiftCtrl, isRightShiftCtrl, isUpShiftCtrl, isDownShiftCtrl, isHome, isEnd, isPlus, isMinus, isHomeCtrl, isEndCtrl, isHomeShift, isEndShift, isEscape, isTabNext, isTabPrevious, isBackSpace, isDelete, isShow, isF4, isF4Shift, isF6Previous, isF6Next, isF7, isPageUp, isPageDown, isPageUpShift, isPageUpAlt, isPageDownShift, isPageDownAlt, isPageUpShiftCtrl, isPageDownShiftCtrl, isShift, isCtrlA, isCtrlV, isDeleteShift, isInsertShift, isInsertCtrl, };
//# sourceMappingURL=Keys.js.map