import type { JSX } from "./jsx-runtime.d.ts";
import scroll from "./animations/scroll.js";
import slideDown from "./animations/slideDown.js";
import slideUp from "./animations/slideUp.js";
import { getAnimationMode, setAnimationMode } from "./config/AnimationMode.js";
import { getCalendarType } from "./config/CalendarType.js";
import { getFirstDayOfWeek, getLegacyDateCalendarCustomizing } from "./config/FormatSettings.js";
import { setDefaultIconCollection, getDefaultIconCollection } from "./config/Icons.js";
import { RegisteredIconCollection } from "./asset-registries/util/IconCollectionsByTheme.js";
import getEffectiveIconCollection from "./asset-registries/util/getIconCollectionByTheme.js";
import { startMultipleDrag } from "./DragAndDrop.js";
import { getLanguage, setLanguage, getDefaultLanguage, setFetchDefaultLanguage, getFetchDefaultLanguage } from "./config/Language.js";
import { getNoConflict, setNoConflict } from "./config/NoConflict.js";
import { getTheme, setTheme, getDefaultTheme } from "./config/Theme.js";
import customElement from "./decorators/customElement.js";
import event from "./decorators/event.js";
import property from "./decorators/property.js";
import slot from "./decorators/slot.js";
import ItemNavigation from "./delegate/ItemNavigation.js";
import ResizeHandler from "./delegate/ResizeHandler.js";
import ScrollEnablement from "./delegate/ScrollEnablement.js";
import applyDirection from "./locale/applyDirection.js";
import { attachDirectionChange, detachDirectionChange } from "./locale/directionChange.js";
import getEffectiveDir from "./locale/getEffectiveDir.js";
import { attachLanguageChange, detachLanguageChange } from "./locale/languageChange.js";
import { URLListValidator, sanitizeHTML } from "./util/HTMLSanitizer.js";
import { registerI18nLoader } from "./asset-registries/i18n.js";
import { registerLocaleDataLoader } from "./asset-registries/LocaleData.js";
import { registerThemePropertiesLoader } from "./asset-registries/Themes.js";
import { registerIconLoader } from "./asset-registries/Icons.js";
import { attachBoot } from "./Boot.js";
import { setCustomElementsScopingSuffix, getCustomElementsScopingSuffix, setCustomElementsScopingRules, getCustomElementsScopingRules, getEffectiveScopingSuffixForTag } from "./CustomElementsScope.js";
import { supportsTouch, isSafari, isChrome, isFirefox, isPhone, isTablet, isDesktop, isCombi, isIOS, isAndroid } from "./Device.js";
import EventProvider from "./EventProvider.js";
import I18nBundle, { getI18nBundle, registerCustomI18nBundleGetter } from "./i18nBundle.js";
import MediaRange from "./MediaRange.js";
import { renderDeferred, renderImmediately, cancelRender, renderFinished } from "./Render.js";
import { addCustomCSS, attachThemeLoaded, detachThemeLoaded } from "./Theming.js";
import UI5Element from "./UI5Element.js";
export default UI5Element;
export { startMultipleDrag, scroll, slideDown, slideUp, getAnimationMode, setAnimationMode, getCalendarType, getFirstDayOfWeek, getLegacyDateCalendarCustomizing, setDefaultIconCollection, getDefaultIconCollection, getEffectiveIconCollection, RegisteredIconCollection, getLanguage, setLanguage, getDefaultLanguage, setFetchDefaultLanguage, getFetchDefaultLanguage, getNoConflict, setNoConflict, getTheme, setTheme, getDefaultTheme, customElement, event, property, slot, ItemNavigation, ResizeHandler, ScrollEnablement, applyDirection, attachDirectionChange, detachDirectionChange, getEffectiveDir, attachLanguageChange, detachLanguageChange, URLListValidator, sanitizeHTML, registerI18nLoader, registerLocaleDataLoader, registerThemePropertiesLoader, registerIconLoader, attachBoot, setCustomElementsScopingSuffix, getCustomElementsScopingSuffix, setCustomElementsScopingRules, getCustomElementsScopingRules, getEffectiveScopingSuffixForTag, supportsTouch, isSafari, isChrome, isFirefox, isPhone, isTablet, isDesktop, isCombi, isIOS, isAndroid, EventProvider, I18nBundle, getI18nBundle, registerCustomI18nBundleGetter, MediaRange, renderDeferred, renderImmediately, cancelRender, renderFinished, addCustomCSS, attachThemeLoaded, detachThemeLoaded, UI5Element, };
type TargetedCustomEvent<D, T> = Omit<CustomEvent<D>, "currentTarget"> & {
    currentTarget: T;
};
export type UI5CustomEvent<T extends UI5Element, N extends keyof T["eventDetails"]> = TargetedCustomEvent<T["eventDetails"][N], T>;
export type JsxTemplateResult = JSX.Element | void;
export type JsxTemplate = () => JsxTemplateResult;
export type * from "./types.d.ts";
export type * from "./jsx-runtime.d.ts";
