import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ClassMap } from "@ui5/webcomponents-base/dist/types.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import SideContentPosition from "./types/SideContentPosition.js";
import SideContentVisibility from "./types/SideContentVisibility.js";
import SideContentFallDown from "./types/SideContentFallDown.js";
type DynamicSideContentLayoutChangeEventDetail = {
    currentBreakpoint: string;
    previousBreakpoint: string;
    mainContentVisible: boolean;
    sideContentVisible: boolean;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The DynamicSideContent (<code>ui5-dynamic-side-content</code>) is a layout component that allows additional content
 * to be displayed in a way that flexibly adapts to different screen sizes. The side
 * content appears in a container next to or directly below the main content
 * (it doesn't overlay). When the side content is triggered, the main content becomes
 * narrower (if appearing side-by-side). The side content contains a separate scrollbar
 * when appearing next to the main content.
 *
 *
 * <h3>Usage</h3>
 *
 * <i>When to use?</i>
 *
 * Use this component if you want to display relevant information that is not critical
 * for users to complete a task. Users should have access to all the key functions and
 * critical information in the app even if they do not see the side content. This is
 * important because on smaller screen sizes it may be difficult to display the side
 * content in a way that is easily accessible for the user.
 *
 * <i>When not to use?</i>
 *
 * Don't use it if you want to display navigation or critical information that prevents
 * users from completing a task when they have no access to the side content.
 *
 *
 * <h3>Responsive Behavior</h3>
 *
 * Screen width > 1440px
 *
 * <ul><li>Main vs. side content ratio is 75 vs. 25 percent (with a minimum of 320px
 * each).</li>
 * <li>If the application defines a trigger, the side content can be hidden.</li></ul>
 *
 * Screen width <= 1440px and > 1024px
 *
 * <ul><li>Main vs. side content ratio is 66.666 vs. 33.333 percent (with a minimum of
 * 320px each). If the side content width falls below 320 px, it automatically slides
 * under the main content, unless the app development team specifies that it should
 * disappear.</li></ul>
 *
 * Screen width <= 1024px and > 720px
 *
 * <ul><li>The side content ratio is fixed to 340px, and the main content takes the rest
 * of the width. Only if the <code>sideContentFallDown</code> is set to <code>OnMinimumWidth</code>
 * and screen width is <= 960px and > 720px the side content falls below the main content.</li></ul>
 *
 * Screen width <= 720px (for example on a mobile device)
 *
 * <ul><li>In this case, the side content automatically disappears from the screen (unless
 * specified to stay under the content by setting of <code>sideContentVisibility</code>
 * property to <code>AlwaysShow</code>) and can be triggered from a pre-set trigger
 * (specified within the app). When the side content is triggered, it replaces the main
 * content. We recommend that you always place the trigger for the side content in the
 * same location, such as in the app footer.</li></ul>
 *
 * A special case allows switching the comparison mode between the main and side content.
 * In this case, the screen is split into 50:50 percent for main vs. side content. The
 * responsive behavior of the equal split is the same as in the standard view - the
 * side content disappears on screen widths of less than 720 px and can only be
 * viewed by triggering it.
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents-fiori/dist/DynamicSideContent";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.DynamicSideContent
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-dynamic-side-content
 * @public
 * @since 1.1.0
 */
declare class DynamicSideContent extends UI5Element {
    /**
     * Defines the visibility of the main content.
     *
     * @type {boolean}
     * @name sap.ui.webc.fiori.DynamicSideContent.prototype.hideMainContent
     * @defaultvalue false
     * @public
     *
     */
    hideMainContent: boolean;
    /**
     * Defines the visibility of the side content.
     *
     * @type {boolean}
     * @name sap.ui.webc.fiori.DynamicSideContent.prototype.hideSideContent
     * @defaultvalue false
     * @public
     *
     */
    hideSideContent: boolean;
    /**
     * Defines whether the side content is positioned before the main content (left side
     * in LTR mode), or after the the main content (right side in LTR mode).
     *
     * <br><br>
     * <b>The available values are:</b>
     *
     * <ul>
     * <li><code>Start</code></li>
     * <li><code>End</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.fiori.types.SideContentPosition}
     * @name sap.ui.webc.fiori.DynamicSideContent.prototype.sideContentPosition
     * @defaultvalue "End"
     * @public
     *
     */
    sideContentPosition: `${SideContentPosition}`;
    /**
     * Defines on which breakpoints the side content is visible.
     *
     * <br><br>
     * <b>The available values are:</b>
     *
     * <ul>
     * <li><code>AlwaysShow</code></li>
     * <li><code>ShowAboveL</code></li>
     * <li><code>ShowAboveM</code></li>
     * <li><code>ShowAboveS</code></li>
     * <li><code>NeverShow</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.fiori.types.SideContentVisibility}
     * @name sap.ui.webc.fiori.DynamicSideContent.prototype.sideContentVisibility
     * @defaultvalue "ShowAboveS"
     * @public
     *
     */
    sideContentVisibility: `${SideContentVisibility}`;
    /**
     * Defines on which breakpoints the side content falls down below the main content.
     *
     * <br><br>
     * <b>The available values are:</b>
     *
     * <ul>
     * <li><code>BelowXL</code></li>
     * <li><code>BelowL</code></li>
     * <li><code>BelowM</code></li>
     * <li><code>OnMinimumWidth</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.fiori.types.SideContentFallDown}
     * @name sap.ui.webc.fiori.DynamicSideContent.prototype.sideContentFallDown
     * @defaultvalue "OnMinimumWidth"
     * @public
     *
     */
    sideContentFallDown: `${SideContentFallDown}`;
    /**
     * Defines whether the component is in equal split mode. In this mode, the side and
     * the main content take 50:50 percent of the container on all screen sizes
     * except for phone, where the main and side contents are switching visibility
     * using the toggle method.
     *
     * @type {boolean}]
     * @name sap.ui.webc.fiori.DynamicSideContent.prototype.equalSplit
     * @defaultvalue false
     * @public
     *
     */
    equalSplit: boolean;
    /**
     * @private
     */
    _mcSpan: string;
    /**
     * @private
     */
    _scSpan: string;
    /**
     * @private
     */
    _toggled: boolean;
    /**
     * @private
     */
    _currentBreakpoint: string;
    /**
     * Defines the main content.
     *
     * @type {HTMLElement[]}
     * @name sap.ui.webc.fiori.DynamicSideContent.prototype.default
     * @slot
     * @public
     */
    /**
     * Defines the side content.
     *
     * @type {HTMLElement[]}
     * @name sap.ui.webc.fiori.DynamicSideContent.prototype.sideContent
     * @slot
     * @public
     */
    sideContent: Array<HTMLElement>;
    constructor();
    _handleResizeBound: () => void;
    static i18nBundle: I18nBundle;
    static onDefine(): Promise<void>;
    onAfterRendering(): void;
    onEnterDOM(): void;
    onExitDOM(): void;
    /**
     * Toggles visibility of main and side contents on S screen size (mobile device).
     * @public
     * @method
     * @name sap.ui.webc.fiori.DynamicSideContent#toggleContents
     */
    toggleContents(): void;
    get classes(): ClassMap;
    get styles(): {
        root: {
            "flex-wrap": string;
        };
        main: {
            height: string;
        };
        side: {
            height: string;
        };
    };
    get accInfo(): {
        label: string;
    };
    get sizeS(): string;
    get sizeM(): string;
    get sizeL(): string;
    get sizeXL(): string;
    get span0(): string;
    get span3(): string;
    get span4(): string;
    get span6(): string;
    get span8(): string;
    get span9(): string;
    get span12(): string;
    get spanFixed(): string;
    get containerWidth(): number;
    get breakpoint(): string;
    get _isSideContentFirst(): boolean;
    handleResize(): void;
    _resizeContents(): void;
    _setSpanSizes(mainSize: string, sideSize: string): void;
}
export default DynamicSideContent;
export type { DynamicSideContentLayoutChangeEventDetail, };
