import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import IllustrationMessageSize from "./types/IllustrationMessageSize.js";
import IllustrationMessageType from "./types/IllustrationMessageType.js";
import "./illustrations/BeforeSearch.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * An IllustratedMessage is a recommended combination of a solution-oriented message, an engaging
 * illustration, and conversational tone to better communicate an empty or a success state than just show
 * a message alone.
 *
 * Each illustration has default internationalised title and subtitle texts. Also they can be managed with
 * <code>titleText</code> and <code>subtitleText</code> properties.
 *
 * To display the desired illustration, use the <code>name</code> property, where you can find the list of all available illustrations.
 * <br><br>
 * <b>Note:</b> By default the “BeforeSearch” illustration is loaded. To use other illustrations, make sure you import them in addition, for example:
 * <br>
 * <code>import "@ui5/webcomponents-fiori/dist/illustrations/NoData.js"</code>
 * <br>
 * <b>Note:</b> Illustrations starting with the “Tnt” prefix are part of another illustration set. For example to use the “TntSuccess” illustration, add the following import::
 * <br>
 * <code>import "@ui5/webcomponents-fiori/dist/illustrations/tnt/Success.js"</code>
 *
 * <h3>Structure</h3>
 * The IllustratedMessage consists of the following elements, which are displayed below each other in the following order:
 * <br>
 * <ul>
 * <li>Illustration</li>
 * <li>Title</li>
 * <li>Subtitle</li>
 * <li>Actions</li>
 * </ul>
 *
 * <h3>Usage</h3>
 * <code>ui5-illustrated-message</code> is meant to be used inside container component, for example a <code>ui5-card</code>,
 * a <code>ui5-dialog</code> or a <code>ui5-page</code>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents-fiori/dist/IllustratedMessage.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.IllustratedMessage
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-illustrated-message
 * @public
 * @since 1.0.0-rc.15
 */
declare class IllustratedMessage extends UI5Element {
    /**
    * Defines the illustration name that will be displayed in the component.
    * <br><br>
    * Available illustrations are:
    * <ul>
    * <li><code>AddColumn</code></li>
    * <li><code>AddPeople</code></li>
    * <li><code>AddDimensions</code></li>
    * <li><code>BalloonSky</code></li>
    * <li><code>BeforeSearch</code></li>
    * <li><code>Connection</code></li>
    * <li><code>EmptyCalendar</code></li>
    * <li><code>EmptyList</code></li>
    * <li><code>EmptyPlanningCalendar</code></li>
    * <li><code>ErrorScreen</code></li>
    * <li><code>FilterTable</code></li>
    * <li><code>GroupTable</code></li>
    * <li><code>NoActivities</code></li>
    * <li><code>NoColumnsSet</code></li>
    * <li><code>NoData</code></li>
    * <li><code>NoEntries</code></li>
    * <li><code>NoFilterResults</code></li>
    * <li><code>NoMail_v1</code></li>
    * <li><code>NoMail</code></li>
    * <li><code>NoNotifications</code></li>
    * <li><code>NoSavedItems_v1</code></li>
    * <li><code>NoSavedItems</code></li>
    * <li><code>NoSearchResults</code></li>
    * <li><code>NoTasks_v1</code></li>
    * <li><code>NoTasks</code></li>
    * <li><code>NoDimensionsSet</code></li>
    * <li><code>PageNotFound</code></li>
    * <li><code>ReloadScreen</code></li>
    * <li><code>ResizeColumn</code></li>
    * <li><code>SearchEarth</code></li>
    * <li><code>SearchFolder</code></li>
    * <li><code>SimpleBalloon</code></li>
    * <li><code>SimpleBell</code></li>
    * <li><code>SimpleCalendar</code></li>
    * <li><code>SimpleCheckMark</code></li>
    * <li><code>SimpleConnection</code></li>
    * <li><code>SimpleEmptyDoc</code></li>
    * <li><code>SimpleEmptyList</code></li>
    * <li><code>SimpleError</code></li>
    * <li><code>SimpleMagnifier</code></li>
    * <li><code>SimpleMail</code></li>
    * <li><code>SimpleNoSavedItems</code></li>
    * <li><code>SimpleNotFoundMagnifier</code></li>
    * <li><code>SimpleReload</code></li>
    * <li><code>SimpleTask</code></li>
    * <li><code>SleepingBell</code></li>
    * <li><code>SortColumn</code></li>
    * <li><code>SuccessBalloon</code></li>
    * <li><code>SuccessCheckMark</code></li>
    * <li><code>SuccessHighFive</code></li>
    * <li><code>SuccessScreen</code></li>
    * <li><code>Survey</code></li>
    * <li><code>Tent</code></li>
    * <li><code>UnableToLoad</code></li>
    * <li><code>UnableToLoadImage</code></li>
    * <li><code>UnableToUpload</code></li>
    * <li><code>UploadToCloud</code></li>
    * <li><code>UploadCollection</code></li>
    * <li><code>TntChartArea</code></li>
    * <li><code>TntChartArea2</code></li>
    * <li><code>TntChartBar</code></li>
    * <li><code>TntChartBPMNFlow</code></li>
    * <li><code>TntChartBullet</code></li>
    * <li><code>TntChartDoughnut</code></li>
    * <li><code>TntChartFlow</code></li>
    * <li><code>TntChartGantt</code></li>
    * <li><code>TntChartOrg</code></li>
    * <li><code>TntChartPie</code></li>
    * <li><code>TntCodePlaceholder</code></li>
    * <li><code>TntCompany</code></li>
    * <li><code>TntComponents</code></li>
    * <li><code>TntExternalLink</code></li>
    * <li><code>TntFaceID</code></li>
    * <li><code>TntFingerprint</code></li>
    * <li><code>TntLock</code></li>
    * <li><code>TntMission</code></li>
    * <li><code>TntNoApplications</code></li>
    * <li><code>TntNoFlows</code></li>
    * <li><code>TntNoUsers</code></li>
    * <li><code>TntRadar</code></li>
    * <li><code>TntSecrets</code></li>
    * <li><code>TntServices</code></li>
    * <li><code>TntSessionExpired</code></li>
    * <li><code>TntSessionExpiring</code></li>
    * <li><code>TntSuccess</code></li>
    * <li><code>TntSuccessfulAuth</code></li>
    * <li><code>TntSystems</code></li>
    * <li><code>TntTeams</code></li>
    * <li><code>TntTools</code></li>
    * <li><code>TntUnableToLoad</code></li>
    * <li><code>TntUnlock</code></li>
    * <li><code>TntUnsuccessfulAuth</code></li>
    * <li><code>TntUser2</code></li>
    * </ul>
    * <br><br>
    * <b>Note:</b> By default the <code>BeforeSearch</code> illustration is loaded.
    * <br>
    * When using an illustration type, other than the default, it should be loaded in addition:
    * <br>
    * <code>import "@ui5/webcomponents-fiori/dist/illustrations/NoData.js";</code>
    * <br><br>
    * <b>Note:</b> TNT illustrations cointain <code>Tnt</code> prefix in their name.
    * You can import them removing the <code>Tnt</code> prefix like this:
    * <br>
    * <code>import "@ui5/webcomponents-fiori/dist/illustrations/tnt/SessionExpired.js";</code>
    * @type {sap.ui.webc.fiori.types.IllustrationMessageType}
    * @defaultvalue "BeforeSearch"
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.name
    * @public
    */
    name: `${IllustrationMessageType}`;
    /**
    * Determines which illustration breakpoint variant is used.
    * <br><br>
    * Available options are:
    * <ul>
    * <li><code>Auto</code></li>
    * <li><code>Base</code></li>
    * <li><code>Spot</code></li>
    * <li><code>Dialog</code></li>
    * <li><code>Scene</code></li>
    * </ul>
    *
    * As <code>IllustratedMessage</code> adapts itself around the <code>Illustration</code>, the other
    * elements of the component are displayed differently on the different breakpoints/illustration sizes.
    *
    * @type {sap.ui.webc.fiori.types.IllustrationMessageSize}
    * @defaultvalue "Auto"
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.size
    * @public
    * @since 1.5.0
    */
    size: `${IllustrationMessageSize}`;
    /**
    * Defines the subtitle of the component.
    * <br><br>
    * <b>Note:</b> Using this property, the default subtitle text of illustration will be overwritten.
    * <br><br>
    * <b>Note:</b> Using <code>subtitle</code> slot, the default of this property will be overwritten.
    * @type {string}
    * @defaultvalue ""
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.subtitleText
    * @public
    */
    subtitleText: string;
    /**
    * Defines the title of the component.
    * <br><br>
    * <b>Note:</b> Using this property, the default title text of illustration will be overwritten.
    * @type {string}
    * @defaultvalue ""
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.titleText
    * @public
    */
    titleText: string;
    /**
    * Receives id(or many ids) of the elements that label the component.
    *
    * @type {string}
    * @defaultvalue ""
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.accessibleNameRef
    * @public
    * @since 1.7.0
    */
    accessibleNameRef: string;
    /**
    * Illustration breakpoint variant for the <code>Spot</code> size.
    *
    * @private
    * @type {String}
    * @since 1.9.0
    */
    spotSvg: string;
    /**
    * Illustration breakpoint variant for the <code>Scene</code> size.
    *
    * @private
    * @type {String}
    * @since 1.9.0
    */
    sceneSvg: string;
    /**
    * Illustration breakpoint variant for the <code>Dialog</code> size.
    *
    * @private
    * @type {String}
    * @since 1.9.0
    */
    dialogSvg: string;
    /**
    * Determinates what is the current media of the component based on its width.
    * @private
    */
    media: string;
    /**
    * Defines the title of the component.
    * <br><br>
    * <b>Note:</b> Using this slot, the default title text of illustration and the value of <code>title</code> property will be overwritten.
    * @type {HTMLElement}
    * @slot title
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.title
    * @public
    * @since 1.7.0
    */
    title: Array<HTMLElement> & string;
    /**
    * Defines the subtitle of the component.
    * <br><br>
    * <b>Note:</b> Using this slot, the default subtitle text of illustration and the value of <code>subtitleText</code> property will be overwritten.
    * @type {HTMLElement}
    * @slot subtitle
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.subtitle
    * @public
    * @since 1.0.0-rc.16
    */
    subtitle: Array<HTMLElement>;
    /**
    * Defines the component actions.
    * @type {sap.ui.webc.main.IButton[]}
    * @slot actions
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.default
    * @public
    */
    actions: Array<HTMLElement>;
    illustrationTitle?: string;
    illustrationSubtitle?: string;
    static i18nBundle: I18nBundle;
    _lastKnownOffsetWidthForMedia: Record<string, number>;
    _lastKnownMedia: string;
    _handleResize: ResizeObserverCallback;
    constructor();
    static onDefine(): Promise<void>;
    static get BREAKPOINTS(): {
        DIALOG: number;
        SPOT: number;
        BASE: number;
    };
    static get MEDIA(): {
        BASE: string;
        SPOT: string;
        DIALOG: string;
        SCENE: string;
    };
    onBeforeRendering(): Promise<void>;
    onEnterDOM(): void;
    onExitDOM(): void;
    handleResize(): void;
    _applyMedia(): void;
    _setSVGAccAttrs(): void;
    onAfterRendering(): void;
    /**
     * Modifies the IM styles in accordance to the `size` property's value.
     * Note: The resize handler has no effect when size is different than "Auto".
     * @private
     * @since 1.5.0
     */
    _handleCustomSize(): void;
    get ariaLabelText(): string | undefined;
    get effectiveIllustration(): string;
    get hasFormattedSubtitle(): boolean;
    get hasFormattedTitle(): boolean;
    get effectiveTitleText(): string | undefined;
    get effectiveSubitleText(): string | undefined;
    get hasTitle(): boolean;
    get hasSubtitle(): boolean;
    get hasActions(): boolean;
    isValidIllustration(currentIllustration: `${IllustrationMessageType}`): boolean;
}
export default IllustratedMessage;
