var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var IllustratedMessage_1;
import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import customElement from "@ui5/webcomponents-base/dist/decorators/customElement.js";
import property from "@ui5/webcomponents-base/dist/decorators/property.js";
import slot from "@ui5/webcomponents-base/dist/decorators/slot.js";
import ResizeHandler from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import { getIllustrationDataSync, getIllustrationData } from "@ui5/webcomponents-base/dist/asset-registries/Illustrations.js";
import { getEffectiveAriaLabelText } from "@ui5/webcomponents-base/dist/util/AriaLabelHelper.js";
import { getI18nBundle } from "@ui5/webcomponents-base/dist/i18nBundle.js";
import Title from "@ui5/webcomponents/dist/Title.js";
import litRender from "@ui5/webcomponents-base/dist/renderer/LitRenderer.js";
import IllustrationMessageSize from "./types/IllustrationMessageSize.js";
import IllustrationMessageType from "./types/IllustrationMessageType.js";
import "./illustrations/BeforeSearch.js";
// Styles
import IllustratedMessageCss from "./generated/themes/IllustratedMessage.css.js";
// Template
import IllustratedMessageTemplate from "./generated/templates/IllustratedMessageTemplate.lit.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * An IllustratedMessage is a recommended combination of a solution-oriented message, an engaging
 * illustration, and conversational tone to better communicate an empty or a success state than just show
 * a message alone.
 *
 * Each illustration has default internationalised title and subtitle texts. Also they can be managed with
 * <code>titleText</code> and <code>subtitleText</code> properties.
 *
 * To display the desired illustration, use the <code>name</code> property, where you can find the list of all available illustrations.
 * <br><br>
 * <b>Note:</b> By default the “BeforeSearch” illustration is loaded. To use other illustrations, make sure you import them in addition, for example:
 * <br>
 * <code>import "@ui5/webcomponents-fiori/dist/illustrations/NoData.js"</code>
 * <br>
 * <b>Note:</b> Illustrations starting with the “Tnt” prefix are part of another illustration set. For example to use the “TntSuccess” illustration, add the following import::
 * <br>
 * <code>import "@ui5/webcomponents-fiori/dist/illustrations/tnt/Success.js"</code>
 *
 * <h3>Structure</h3>
 * The IllustratedMessage consists of the following elements, which are displayed below each other in the following order:
 * <br>
 * <ul>
 * <li>Illustration</li>
 * <li>Title</li>
 * <li>Subtitle</li>
 * <li>Actions</li>
 * </ul>
 *
 * <h3>Usage</h3>
 * <code>ui5-illustrated-message</code> is meant to be used inside container component, for example a <code>ui5-card</code>,
 * a <code>ui5-dialog</code> or a <code>ui5-page</code>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents-fiori/dist/IllustratedMessage.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.IllustratedMessage
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-illustrated-message
 * @public
 * @since 1.0.0-rc.15
 */
let IllustratedMessage = IllustratedMessage_1 = class IllustratedMessage extends UI5Element {
    constructor() {
        super();
        this._handleResize = this.handleResize.bind(this);
        // this will store the last known offsetWidth of the IllustratedMessage DOM node for a given media (e.g. "Spot")
        this._lastKnownOffsetWidthForMedia = {};
        // this will store the last known media, in order to detect if IllustratedMessage has been hidden by expand/collapse container
        this._lastKnownMedia = "base";
    }
    static async onDefine() {
        IllustratedMessage_1.i18nBundle = await getI18nBundle("@ui5/webcomponents-fiori");
    }
    static get BREAKPOINTS() {
        return {
            DIALOG: 679,
            SPOT: 319,
            BASE: 259,
        };
    }
    static get MEDIA() {
        return {
            BASE: "base",
            SPOT: "spot",
            DIALOG: "dialog",
            SCENE: "scene",
        };
    }
    async onBeforeRendering() {
        let illustrationData = getIllustrationDataSync(this.name);
        // Gets the current illustration name given in the "name" attribute
        const currentIllustration = this.getAttribute("name");
        if (this.hasAttribute("name") && !this.isValidIllustration(currentIllustration)) {
            // eslint-disable-next-line
            console.warn(`The illustration "${currentIllustration}" does not exist. The default illustration "${IllustrationMessageType.BeforeSearch}" is loaded instead.`);
        }
        if (illustrationData === undefined) {
            illustrationData = await getIllustrationData(this.name);
        }
        this.spotSvg = illustrationData.spotSvg;
        this.dialogSvg = illustrationData.dialogSvg;
        this.sceneSvg = illustrationData.sceneSvg;
        this.illustrationTitle = IllustratedMessage_1.i18nBundle.getText(illustrationData.title);
        this.illustrationSubtitle = IllustratedMessage_1.i18nBundle.getText(illustrationData.subtitle);
        if (this.size !== IllustrationMessageSize.Auto) {
            this._handleCustomSize();
        }
    }
    onEnterDOM() {
        ResizeHandler.register(this, this._handleResize);
    }
    onExitDOM() {
        ResizeHandler.deregister(this, this._handleResize);
    }
    handleResize() {
        if (this.size !== IllustrationMessageSize.Auto) {
            return;
        }
        this._applyMedia();
    }
    _applyMedia() {
        const currOffsetWidth = this.offsetWidth;
        let newMedia = "";
        if (this.offsetWidth <= IllustratedMessage_1.BREAKPOINTS.BASE) {
            newMedia = IllustratedMessage_1.MEDIA.BASE;
        }
        else if (this.offsetWidth <= IllustratedMessage_1.BREAKPOINTS.SPOT) {
            newMedia = IllustratedMessage_1.MEDIA.SPOT;
        }
        else if (this.offsetWidth <= IllustratedMessage_1.BREAKPOINTS.DIALOG) {
            newMedia = IllustratedMessage_1.MEDIA.DIALOG;
        }
        else {
            newMedia = IllustratedMessage_1.MEDIA.SCENE;
        }
        const lastKnownOffsetWidth = this._lastKnownOffsetWidthForMedia[newMedia];
        // prevents infinite resizing, when same width is detected for the same media,
        // excluding the case in which, the control is placed inside expand/collapse container
        if (!(lastKnownOffsetWidth && currOffsetWidth === lastKnownOffsetWidth) || this._lastKnownOffsetWidthForMedia[this._lastKnownMedia] === 0) {
            this.media = newMedia;
            this._lastKnownOffsetWidthForMedia[newMedia] = currOffsetWidth;
            this._lastKnownMedia = newMedia;
        }
    }
    _setSVGAccAttrs() {
        const svg = this.shadowRoot.querySelector(".ui5-illustrated-message-illustration svg");
        if (svg) {
            if (this.ariaLabelText) {
                svg.setAttribute("aria-label", this.ariaLabelText);
            }
            else {
                svg.removeAttribute("aria-label");
            }
        }
    }
    onAfterRendering() {
        this._setSVGAccAttrs();
    }
    /**
     * Modifies the IM styles in accordance to the `size` property's value.
     * Note: The resize handler has no effect when size is different than "Auto".
     * @private
     * @since 1.5.0
     */
    _handleCustomSize() {
        switch (this.size) {
            case IllustrationMessageSize.Base:
                this.media = IllustratedMessage_1.MEDIA.BASE;
                return;
            case IllustrationMessageSize.Spot:
                this.media = IllustratedMessage_1.MEDIA.SPOT;
                return;
            case IllustrationMessageSize.Dialog:
                this.media = IllustratedMessage_1.MEDIA.DIALOG;
                return;
            default:
                this.media = IllustratedMessage_1.MEDIA.SCENE;
        }
    }
    get ariaLabelText() {
        return getEffectiveAriaLabelText(this);
    }
    get effectiveIllustration() {
        switch (this.media) {
            case IllustratedMessage_1.MEDIA.SPOT:
                return this.spotSvg;
            case IllustratedMessage_1.MEDIA.DIALOG:
                return this.dialogSvg;
            case IllustratedMessage_1.MEDIA.SCENE:
                return this.sceneSvg;
            default:
                return "";
        }
    }
    get hasFormattedSubtitle() {
        return !!this.subtitle.length;
    }
    get hasFormattedTitle() {
        return !!this.title.length;
    }
    get effectiveTitleText() {
        return this.titleText ? this.titleText : this.illustrationTitle;
    }
    get effectiveSubitleText() {
        return this.subtitleText ? this.subtitleText : this.illustrationSubtitle;
    }
    get hasTitle() {
        return !!(this.hasFormattedTitle || this.titleText || this.illustrationTitle);
    }
    get hasSubtitle() {
        return !!(this.hasFormattedSubtitle || this.subtitleText || this.illustrationSubtitle);
    }
    get hasActions() {
        return !!this.actions.length && this.media !== IllustratedMessage_1.MEDIA.BASE;
    }
    isValidIllustration(currentIllustration) {
        return currentIllustration in IllustrationMessageType;
    }
};
__decorate([
    property({ type: IllustrationMessageType, defaultValue: IllustrationMessageType.BeforeSearch })
], IllustratedMessage.prototype, "name", void 0);
__decorate([
    property({ type: IllustrationMessageSize, defaultValue: IllustrationMessageSize.Auto })
], IllustratedMessage.prototype, "size", void 0);
__decorate([
    property()
], IllustratedMessage.prototype, "subtitleText", void 0);
__decorate([
    property()
], IllustratedMessage.prototype, "titleText", void 0);
__decorate([
    property({ defaultValue: "" })
], IllustratedMessage.prototype, "accessibleNameRef", void 0);
__decorate([
    property({ noAttribute: true })
], IllustratedMessage.prototype, "spotSvg", void 0);
__decorate([
    property({ noAttribute: true })
], IllustratedMessage.prototype, "sceneSvg", void 0);
__decorate([
    property({ noAttribute: true })
], IllustratedMessage.prototype, "dialogSvg", void 0);
__decorate([
    property()
], IllustratedMessage.prototype, "media", void 0);
__decorate([
    slot({ type: HTMLElement })
], IllustratedMessage.prototype, "title", void 0);
__decorate([
    slot({ type: HTMLElement })
], IllustratedMessage.prototype, "subtitle", void 0);
__decorate([
    slot({ type: HTMLElement, "default": true })
], IllustratedMessage.prototype, "actions", void 0);
IllustratedMessage = IllustratedMessage_1 = __decorate([
    customElement({
        tag: "ui5-illustrated-message",
        languageAware: true,
        renderer: litRender,
        styles: IllustratedMessageCss,
        template: IllustratedMessageTemplate,
        dependencies: [Title],
    })
], IllustratedMessage);
IllustratedMessage.define();
export default IllustratedMessage;
//# sourceMappingURL=IllustratedMessage.js.map