import ItemNavigation from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import Button from "@ui5/webcomponents/dist/Button.js";
import type { CarouselNavigateEventDetail } from "@ui5/webcomponents/dist/Carousel.js";
import Carousel from "@ui5/webcomponents/dist/Carousel.js";
import type { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import MediaGalleryItem from "./MediaGalleryItem.js";
import MediaGalleryLayout from "./types/MediaGalleryLayout.js";
import MediaGalleryMenuHorizontalAlign from "./types/MediaGalleryMenuHorizontalAlign.js";
import MediaGalleryMenuVerticalAlign from "./types/MediaGalleryMenuVerticalAlign.js";
type MediaGallerySelectionChangeEventDetail = {
    item: MediaGalleryItem;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-media-gallery</code> component allows the user to browse through multimedia items. Currently,
 * the supported items are images and videos. The items should be defined using the <code>ui5-media-gallery-item</code>
 * component.
 *
 * The items are initially displayed as thumbnails. When the user selects a thumbnail, the corresponding item
 * is displayed in larger size.
 * <br>
 * The component is responsive by default and adjusts the position of the menu with respect to viewport size,
 * but the application is able to further customize the layout via the provided API.
 *
* <h3>Keyboard Handling</h3>
 * The <code>ui5-media-gallery</code> provides advanced keyboard handling.
 * <br>
 * When the thumbnails menu is focused the following keyboard
 * shortcuts allow the user to navigate through the thumbnail items:
 * <br>
 *
 * <ul>
 * <li>[UP/DOWN] - Navigates up and down the items</li>
 * <li>[HOME] - Navigates to first item</li>
 * <li>[END] - Navigates to the last item</li>
 * <li>[SPACE/ENTER] - Select an item</li>
 * </ul>
 * <br>
 *
 * <h3>ES6 Module Import</h3>
 * <code>import "@ui5/webcomponents-fiori/dist/MediaGallery";</code>
 * <br>
 * <code>import "@ui5/webcomponents-fiori/dist/MediaGalleryItem";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.MediaGallery
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-media-gallery
 * @appenddocs sap.ui.webc.fiori.MediaGalleryItem
 * @public
 * @since 1.1.0
 */
declare class MediaGallery extends UI5Element {
    /**
     * If set to <code>true</code>, all thumbnails are rendered in a scrollable container.
     * If <code>false</code>, only up to five thumbnails are rendered, followed by
     * an overflow button that shows the count of the remaining thumbnails.
     *
     * @type {boolean}
     * @name sap.ui.webc.fiori.MediaGallery.prototype.showAllThumbnails
     * @defaultvalue false
     * @public
     */
    showAllThumbnails: boolean;
    /**
     * If enabled, a <code>display-area-click</code> event is fired
     * when the user clicks or taps on the display area.
     * <br>
     * The display area is the central area that contains
     * the enlarged content of the currently selected item.
     *
     * @type {boolean}
     * @name sap.ui.webc.fiori.MediaGallery.prototype.interactiveDisplayArea
     * @defaultvalue false
     * @public
     */
    interactiveDisplayArea: boolean;
    /**
     * Determines the layout of the component.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>Auto</code></li>
     * <li><code>Vertical</code></li>
     * <li><code>Horizontal</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.fiori.types.MediaGalleryLayout}
     * @name sap.ui.webc.fiori.MediaGallery.prototype.layout
     * @defaultvalue "Auto"
     * @public
     */
    layout: `${MediaGalleryLayout}`;
    /**
     * Determines the horizontal alignment of the thumbnails menu
     * vs. the central display area.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>Left</code></li>
     * <li><code>Right</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.fiori.types.MediaGalleryMenuHorizontalAlign}
     * @name sap.ui.webc.fiori.MediaGallery.prototype.menuHorizontalAlign
     * @defaultvalue "Left"
     * @public
     */
    menuHorizontalAlign: `${MediaGalleryMenuHorizontalAlign}`;
    /**
     * Determines the vertical alignment of the thumbnails menu
     * vs. the central display area.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>Top</code></li>
     * <li><code>Bottom</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.fiori.types.MediaGalleryMenuVerticalAlign}
     * @name sap.ui.webc.fiori.MediaGallery.prototype.menuVerticalAlign
     * @defaultvalue "Bottom"
     * @public
     */
    menuVerticalAlign: `${MediaGalleryMenuVerticalAlign}`;
    /**
     * Determines the actual applied layout type
     * (esp. needed when the app did not specify a fixed layout type
     * but selected <code>Auto</code> layout type).
     * <br><br>
     * Possible values are:
     * <ul>
     * <li><code>Vertical</code></li>
     * <li><code>Horizontal</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.fiori.types.MediaGalleryLayout}
     * @defaultvalue "Vertical"
     * @private
     */
    effectiveLayout: `${MediaGalleryLayout}`;
    /**
     * Defines the current media query size.
     *
     * @private
     */
    mediaRange: string;
    /**
     * The number of items in the overflow.
     *
     * @private
     */
    _overflowSize: number;
    /**
     * Defines the component items.
     *
     * <br><br>
     * <b>Note:</b> Only one selected item is allowed.
     *
     * <br><br>
     * <b>Note:</b> Use the <code>ui5-media-gallery-item</code> component to define the desired items.
     *
     * @type {sap.ui.webc.fiori.IMediaGalleryItem[]}
     * @name sap.ui.webc.fiori.MediaGallery.prototype.default
     * @slot items
     * @public
     */
    items: Array<MediaGalleryItem>;
    _itemNavigation: ItemNavigation;
    _onResize: () => void;
    _selectedItem?: MediaGalleryItem;
    constructor();
    onEnterDOM(): void;
    onExitDOM(): void;
    onAfterRendering(): void;
    _updateSelection(): void;
    _isSelectableItem(this: void, item: MediaGalleryItem): boolean;
    _findSelectableItem(): MediaGalleryItem | undefined;
    _updateMediaRange(width: number): void;
    _updateLayout(): void;
    _calculateOverflowSize(width: number, height: number): number;
    _toggleDisplaySquareSize(enable: boolean): void;
    _toggleMainItem9x16size(enable: boolean): void;
    _infereffectiveLayout(): MediaGalleryLayout.Vertical | MediaGalleryLayout.Horizontal | "Vertical" | "Horizontal";
    _getMaxAllowedThumbnailsInColumn(columnHeight: number): number;
    _getOverflowSize(columnHeight: number, columnsCount: number): number;
    _getFocusableItems(): ITabbable[];
    _selectItem(item: MediaGalleryItem, userInteraction?: boolean): void;
    _updateSelectedFlag(itemToSelect: MediaGalleryItem): void;
    _selectItemOnPhone(item: MediaGalleryItem): void;
    _displayContent(item: MediaGalleryItem): void;
    _onThumbnailClick(e: MouseEvent): void;
    _onOverflowBtnClick(): void;
    _onDisplayAreaClick(): void;
    _onCarouselNavigate(e: CustomEvent<CarouselNavigateEventDetail>): void;
    get _mainItemTabIndex(): 0 | undefined;
    get _selectableItems(): MediaGalleryItem[];
    get _carousel(): Carousel | null;
    get _display(): HTMLElement | null;
    get _mainItem(): MediaGalleryItem | null;
    get _overflowBtn(): Button | null;
    get _visibleItems(): MediaGalleryItem[];
    get _isPhonePlatform(): boolean;
    get _showThumbnails(): boolean;
    get _showOverflowBtn(): boolean;
    get _isPhoneSize(): boolean;
    get _mainItemHasWideLayout(): boolean | null;
    get _shouldHaveWideDisplay(): boolean;
    get _shouldHaveSquareDisplay(): boolean;
    static get THUMBNAIL_HEIGHT(): number;
    static get THUMBNAIL_MARGIN(): number;
}
export default MediaGallery;
export type { MediaGallerySelectionChangeEventDetail };
