var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import litRender from "@ui5/webcomponents-base/dist/renderer/LitRenderer.js";
import { isSpace, isEnter } from "@ui5/webcomponents-base/dist/Keys.js";
import { isPhone } from "@ui5/webcomponents-base/dist/Device.js";
import Icon from "@ui5/webcomponents/dist/Icon.js";
import "@ui5/webcomponents-icons/dist/background.js";
import customElement from "@ui5/webcomponents-base/dist/decorators/customElement.js";
import property from "@ui5/webcomponents-base/dist/decorators/property.js";
import slot from "@ui5/webcomponents-base/dist/decorators/slot.js";
import MediaGalleryItemLayout from "./types/MediaGalleryItemLayout.js";
// Styles
import MediaGalleryItemCss from "./generated/themes/MediaGalleryItem.css.js";
// Template
import MediaGalleryItemTemplate from "./generated/templates/MediaGalleryItemTemplate.lit.js";
/**
 * @class
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-media-gallery-item</code> web component represents the items displayed in the
 * <code>ui5-media-gallery</code> web component.
 * <br><br>
 * <b>Note:</b> <code>ui5-media-gallery-item</code> is not supported when used outside of <code>ui5-media-gallery</code>.
 * <br><br>
 *
 * <h3>Keyboard Handling</h3>
 * The <code>ui5-media-gallery</code> provides advanced keyboard handling.
 * When focused, the user can use the following keyboard
 * shortcuts in order to perform a navigation:
 * <br>
 * <ul>
 * <li>[SPACE/ENTER/RETURN] - Trigger <code>ui5-click</code> event</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 * <code>import "@ui5/webcomponents-fiori/dist/MediaGalleryItem.js";</code> (comes with <code>ui5-media-gallery</code>)
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.MediaGalleryItem
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-media-gallery-item
 * @public
 * @implements sap.ui.webc.fiori.IMediaGalleryItem
 * @since 1.1.0
 */
let MediaGalleryItem = class MediaGalleryItem extends UI5Element {
    constructor() {
        super();
        this._monitoredContent = null;
        this._monitoredThumbnail = null;
    }
    onEnterDOM() {
        this._thumbnailDesign = !isPhone();
        this._interactive = !isPhone();
        this._square = true;
    }
    get _thumbnail() {
        return this.thumbnail.length ? this.thumbnail[0] : null;
    }
    get _content() {
        return this.content.length ? this.content[0] : null;
    }
    get _isThubmnailAvailable() {
        return this._thumbnail && !this._thumbnailNotFound;
    }
    get _isContentAvailable() {
        return this._content && !this._contentImageNotFound;
    }
    get _useThumbnail() {
        return this._thumbnailDesign && this._isThubmnailAvailable;
    }
    get _useContent() {
        return !this._useThumbnail && this._isContentAvailable;
    }
    get effectiveTabIndex() {
        return this.disabled ? undefined : this._tabIndex;
    }
    get _showBackgroundIcon() {
        return this._thumbnailNotFound || this._contentImageNotFound;
    }
    get styles() {
        return {
            wrapper: {
                height: this.contentHeight,
            },
        };
    }
    get _role() {
        return this._interactive ? "button" : undefined;
    }
    onBeforeRendering() {
        this._monitorLoadingError();
    }
    _monitorLoadingError() {
        let callback, success;
        if (this._thumbnailDesign && this.thumbnail.length && (this._monitoredThumbnail !== this._thumbnail)) {
            this._thumbnailNotFound = false; // reset flag
            callback = this._updateThumbnailLoaded.bind(this);
            success = this._attachListeners(this._thumbnail, callback);
            success && (this._monitoredThumbnail = this._thumbnail);
        }
        if (!this._useThumbnail && this.content.length && (this._monitoredContent !== this._content)) {
            this._contentImageNotFound = false; // reset flag
            callback = this._updateContentImageLoaded.bind(this);
            success = this._attachListeners(this._content, callback);
            success && (this._monitoredContent = this._content);
        }
    }
    _attachListeners(element, callback) {
        const isImg = element.tagName === "IMG", img = isImg ? element : element.querySelector("img");
        if (img) {
            callback(img);
            img.addEventListener("error", () => {
                if (this.contains(img)) { // img still belongs to us
                    callback(img);
                }
            });
            img.addEventListener("load", () => {
                if (this.contains(img)) { // img still belongs to us
                    callback(img);
                }
            });
            return true;
        }
    }
    _updateContentImageLoaded(image) {
        this._contentImageNotFound = image.naturalHeight === 0 && image.naturalWidth === 0;
    }
    _updateThumbnailLoaded(image) {
        this._thumbnailNotFound = image.naturalHeight === 0 && image.naturalWidth === 0;
    }
    _onkeydown(e) {
        if (isSpace(e)) {
            e.preventDefault();
        }
        if (isEnter(e)) {
            this._fireItemClick();
        }
    }
    _onkeyup(e) {
        if (isSpace(e)) {
            this._fireItemClick();
        }
    }
    _onfocusout() {
        this.focused = false;
    }
    _onfocusin() {
        this.focused = true;
    }
    _fireItemClick() {
        this.fireEvent("click", { item: this });
    }
};
__decorate([
    property({ type: Boolean })
], MediaGalleryItem.prototype, "selected", void 0);
__decorate([
    property({ type: Boolean })
], MediaGalleryItem.prototype, "disabled", void 0);
__decorate([
    property({ type: MediaGalleryItemLayout, defaultValue: MediaGalleryItemLayout.Square })
], MediaGalleryItem.prototype, "layout", void 0);
__decorate([
    property({ type: Boolean })
], MediaGalleryItem.prototype, "_interactive", void 0);
__decorate([
    property({ type: Boolean })
], MediaGalleryItem.prototype, "_square", void 0);
__decorate([
    property({ type: Boolean })
], MediaGalleryItem.prototype, "_contentImageNotFound", void 0);
__decorate([
    property({ type: Boolean })
], MediaGalleryItem.prototype, "_thumbnailNotFound", void 0);
__decorate([
    property({ type: Boolean })
], MediaGalleryItem.prototype, "_thumbnailDesign", void 0);
__decorate([
    property({ type: Boolean })
], MediaGalleryItem.prototype, "focused", void 0);
__decorate([
    property()
], MediaGalleryItem.prototype, "_tabIndex", void 0);
__decorate([
    property({ noAttribute: true })
], MediaGalleryItem.prototype, "contentHeight", void 0);
__decorate([
    slot({ type: HTMLElement, "default": true })
], MediaGalleryItem.prototype, "content", void 0);
__decorate([
    slot()
], MediaGalleryItem.prototype, "thumbnail", void 0);
MediaGalleryItem = __decorate([
    customElement({
        tag: "ui5-media-gallery-item",
        renderer: litRender,
        styles: MediaGalleryItemCss,
        template: MediaGalleryItemTemplate,
        dependencies: [Icon],
    })
], MediaGalleryItem);
MediaGalleryItem.define();
export default MediaGalleryItem;
//# sourceMappingURL=MediaGalleryItem.js.map