import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import ListItemBase from "@ui5/webcomponents/dist/ListItemBase.js";
import Priority from "@ui5/webcomponents/dist/types/Priority.js";
import type Popover from "@ui5/webcomponents/dist/Popover.js";
import type NotificationAction from "./NotificationAction.js";
import "@ui5/webcomponents-icons/dist/decline.js";
import "@ui5/webcomponents-icons/dist/message-success.js";
import "@ui5/webcomponents-icons/dist/message-error.js";
import "@ui5/webcomponents-icons/dist/message-warning.js";
import "@ui5/webcomponents-icons/dist/overflow.js";
type NotificationListItemBaseCloseEventDetail = {
    item: HTMLElement;
};
/**
 * @class
 *
 * The base class of the <code>NotificationListItem</code> and <code>NotificationListGroupItem</code>.
 *
 * @abstract
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.NotificationListItemBase
 * @extends sap.ui.webc.main.ListItemBase
 * @since 1.0.0-rc.8
 * @public
 */
/**
 * Fired when the <code>Close</code> button is pressed.
 *
 * @event sap.ui.webc.fiori.NotificationListItemBase#close
 * @param {HTMLElement} item the closed item.
 * @public
 */
declare class NotificationListItemBase extends ListItemBase {
    /**
     * Defines the <code>titleText</code> of the item.
     * @type {string}
     * @defaultvalue ""
     * @public
     * @name sap.ui.webc.fiori.NotificationListItemBase.prototype.titleText
     */
    titleText: string;
    /**
     * Defines the <code>priority</code> of the item.
     * Available options are:
     * <ul>
     * <li><code>None</code></li>
     * <li><code>Low</code></li>
     * <li><code>Medium</code></li>
     * <li><code>High</code></li>
     * </ul>
     * @type {sap.ui.webc.main.types.Priority}
     * @defaultvalue "None"
     * @public
     * @name sap.ui.webc.fiori.NotificationListItemBase.prototype.priority
     */
    priority: `${Priority}`;
    /**
     * Defines if the <code>close</code> button would be displayed.
     * @type {boolean}
     * @defaultvalue false
     * @public
     * @name sap.ui.webc.fiori.NotificationListItemBase.prototype.showClose
     */
    showClose: boolean;
    /**
     * Defines if the <code>notification</code> is new or has been already read.
     * <br><br>
     * <b>Note:</b> if set to <code>false</code> the <code>titleText</code> has bold font,
     * if set to true - it has a normal font.
     * @type {boolean}
     * @defaultvalue false
     * @public
     * @name sap.ui.webc.fiori.NotificationListItemBase.prototype.read
     */
    read: boolean;
    /**
     * Defines if a busy indicator would be displayed over the item.
     * @type {boolean}
     * @defaultvalue false
     * @public
     * @name sap.ui.webc.fiori.NotificationListItemBase.prototype.busy
     * @since 1.0.0-rc.8
     */
    busy: boolean;
    /**
     * Defines the delay in milliseconds, after which the busy indicator will show up for this component.
     *
     * @type {sap.ui.webc.base.types.Integer}
     * @defaultValue 1000
     * @public
     * @name sap.ui.webc.fiori.NotificationListItemBase.prototype.busyDelay
     */
    busyDelay: number;
    /**
     * Defines the actions, displayed in the top-right area.
     * <br><br>
     * <b>Note:</b> use the <code>ui5-notification-action</code> component.
     *
     * @type {sap.ui.webc.fiori.INotificationAction[]}
     * @slot
     * @public
     * @name sap.ui.webc.fiori.NotificationListItemBase.prototype.actions
     */
    actions: Array<NotificationAction>;
    static i18nFioriBundle: I18nBundle;
    get hasTitleText(): boolean;
    get hasPriority(): boolean;
    get priorityIcon(): string;
    get overflowButtonDOM(): HTMLElement;
    get showOverflow(): boolean;
    get overflowActions(): {
        icon: string;
        text: string;
        press: (e: MouseEvent) => void;
        refItemid: string;
        disabled: boolean | undefined;
        design: "Default" | "Positive" | "Negative" | "Transparent" | "Emphasized" | "Attention";
    }[];
    get standardActions(): {
        icon: string;
        text: string;
        press: (e: MouseEvent) => void;
        refItemid: string;
        disabled: boolean | undefined;
        design: "Default" | "Positive" | "Negative" | "Transparent" | "Emphasized" | "Attention";
    }[];
    get actionsInfo(): {
        icon: string;
        text: string;
        press: (e: MouseEvent) => void;
        refItemid: string;
        disabled: boolean | undefined;
        design: "Default" | "Positive" | "Negative" | "Transparent" | "Emphasized" | "Attention";
    }[];
    /**
     * Event handlers
     */
    _onBtnCloseClick(): void;
    _onBtnOverflowClick(): void;
    _onCustomActionClick(e: MouseEvent): void;
    _onkeydown(e: KeyboardEvent): void;
    getActionByID(id: string): NotificationAction | undefined;
    openOverflow(): Promise<void>;
    closeOverflow(): Promise<void>;
    getOverflowPopover(): Promise<Popover>;
    static onDefine(): Promise<void>;
}
export default NotificationListItemBase;
export type { NotificationListItemBaseCloseEventDetail, };
