var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import customElement from "@ui5/webcomponents-base/dist/decorators/customElement.js";
import event from "@ui5/webcomponents-base/dist/decorators/event.js";
import property from "@ui5/webcomponents-base/dist/decorators/property.js";
import slot from "@ui5/webcomponents-base/dist/decorators/slot.js";
import HasPopup from "@ui5/webcomponents/dist/types/HasPopup.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-side-navigation-item</code> is used within <code>ui5-side-navigation</code> only.
 * Via the <code>ui5-side-navigation-item</code> you control the content of the <code>SideNavigation</code>.
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents-fiori/dist/SideNavigationItem.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.SideNavigationItem
 * @extends sap.ui.webc.base.UI5Element
 * @abstract
 * @tagname ui5-side-navigation-item
 * @public
 * @implements sap.ui.webc.fiori.ISideNavigationItem
 * @since 1.0.0-rc.8
 */
let SideNavigationItem = class SideNavigationItem extends UI5Element {
    get _tooltip() {
        return this.title || this.text;
    }
    get _ariaHasPopup() {
        if (this.parentNode.collapsed && this.items.length) {
            return HasPopup.Tree;
        }
        return undefined;
    }
};
__decorate([
    property()
], SideNavigationItem.prototype, "text", void 0);
__decorate([
    property()
], SideNavigationItem.prototype, "icon", void 0);
__decorate([
    property({ type: Boolean })
], SideNavigationItem.prototype, "expanded", void 0);
__decorate([
    property({ type: Boolean })
], SideNavigationItem.prototype, "selected", void 0);
__decorate([
    property({ type: Boolean })
], SideNavigationItem.prototype, "wholeItemToggleable", void 0);
__decorate([
    property()
], SideNavigationItem.prototype, "title", void 0);
__decorate([
    property({ type: Boolean })
], SideNavigationItem.prototype, "_fixed", void 0);
__decorate([
    slot({ type: HTMLElement, invalidateOnChildChange: true, "default": true })
], SideNavigationItem.prototype, "items", void 0);
SideNavigationItem = __decorate([
    customElement("ui5-side-navigation-item")
    /**
     * Fired when the component is activated either with a
     * click/tap or by using the Enter or Space key.
     *
     * @event sap.ui.webc.fiori.SideNavigationItem#click
     * @public
     */
    ,
    event("click")
], SideNavigationItem);
SideNavigationItem.define();
export default SideNavigationItem;
//# sourceMappingURL=SideNavigationItem.js.map