import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import ItemNavigation from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import TimelineItem from "./TimelineItem.js";
import TimelineLayout from "./types/TimelineLayout.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-timeline</code> component shows entries (such as objects, events, or posts) in chronological order.
 * A common use case is to provide information about changes to an object, or events related to an object.
 * These entries can be generated by the system (for example, value XY changed from A to B), or added manually.
 * There are two distinct variants of the timeline: basic and social. The basic timeline is read-only,
 * while the social timeline offers a high level of interaction and collaboration, and is integrated within SAP Jam.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.Timeline
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-timeline
 * @appenddocs sap.ui.webc.fiori.TimelineItem
 * @public
 * @since 0.8.0
 */
declare class Timeline extends UI5Element {
    /**
     * Defines the items orientation.
     *
     * <br><br>
     * <b>Note:</b>
     * Available options are:
     * <ul>
     * <li><code>Vertical</code></li>
     * <li><code>Horizontal</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.fiori.types.TimelineLayout}
     * @name sap.ui.webc.fiori.Timeline.prototype.layout
     * @defaultvalue "Vertical"
     * @since 1.0.0-rc.15
     * @public
     */
    layout: `${TimelineLayout}`;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @name sap.ui.webc.fiori.Timeline.prototype.accessibleName
     * @defaultvalue: ""
     * @public
     * @since 1.2.0
     */
    accessibleName: string;
    /**
     * Determines the content of the <code>ui5-timeline</code>.
     *
     * @type {sap.ui.webc.fiori.ITimelineItem[]}
     * @name sap.ui.webc.fiori.Timeline.prototype.default
     * @slot items
     * @public
     */
    items: Array<TimelineItem>;
    static i18nBundle: I18nBundle;
    _itemNavigation: ItemNavigation;
    constructor();
    static onDefine(): Promise<void>;
    get ariaLabel(): string;
    _onfocusin(e: FocusEvent): void;
    onBeforeRendering(): void;
    _onkeydown(e: KeyboardEvent): void;
    _handleTabNextOrPrevious(e: KeyboardEvent, isNext?: boolean): void;
}
export default Timeline;
