import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import Dialog from "@ui5/webcomponents/dist/Dialog.js";
import List from "@ui5/webcomponents/dist/List.js";
import type { ListItemClickEventDetail } from "@ui5/webcomponents/dist/List.js";
import ViewSettingsDialogMode from "./types/ViewSettingsDialogMode.js";
import "@ui5/webcomponents-icons/dist/sort.js";
import "@ui5/webcomponents-icons/dist/filter.js";
import "@ui5/webcomponents-icons/dist/nav-back.js";
import type SortItem from "./SortItem.js";
import type FilterItem from "./FilterItem.js";
type VSDFilter = Record<string, Array<string>>;
type VSDFilters = Array<VSDFilter>;
type VSDSettings = {
    sortOrder: string;
    sortBy: string;
    filters: VSDFilters;
};
type ViewSettingsDialogConfirmEventDetail = VSDSettings & {
    sortByItem: SortItem;
    sortDescending: boolean;
};
type ViewSettingsDialogCancelEventDetail = VSDSettings & {
    sortByItem: SortItem;
    sortDescending: boolean;
};
type VSDItem = {
    text: string;
    selected: boolean;
};
type VSDInternalSettings = {
    sortOrder: Array<VSDItem>;
    sortBy: Array<VSDItem & {
        index: number;
    }>;
    filters: Array<VSDItem & {
        filterOptions: Array<VSDItem>;
    }>;
};
/**
 * @class
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-view-settings-dialog</code> component helps the user to sort data within a list or a table.
 * It consists of several lists like <code>Sort order</code> which is built-in and <code>Sort By</code> and <code>Filter By</code> lists,
 * for which you must be provide items(<code>ui5-sort-item</code> & <code>ui5-filter-item</code> respectively)
 * These options can be used to create sorters for a table.
 *
 * The <code>ui5-view-settings-dialog</code> interrupts the current application processing as it is the only focused UI element and
 * the main screen is dimmed/blocked.
 * The <code>ui5-view-settings-dialog</code> is modal, which means that user action is required before returning to the parent window is possible.
 *
 * <h3>Structure</h3>
 * A <code>ui5-view-settings-dialog</code> consists of a header, content, and a footer for action buttons.
 * The <code>ui5-view-settings-dialog</code> is usually displayed at the center of the screen.
 *
 * <h3>Responsive Behavior</h3>
 * <code>ui5-view-settings-dialog</code> stretches on full screen on phones.
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents-fiori/dist/ViewSettingsDialog";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.ViewSettingsDialog
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-view-settings-dialog
 * @appenddocs sap.ui.webc.fiori.SortItem sap.ui.webc.fiori.FilterItem sap.ui.webc.fiori.FilterItemOption
 * @since 1.0.0-rc.16
 * @public
 */
declare class ViewSettingsDialog extends UI5Element {
    /**
     * Defines the initial sort order.
     *
     * @name sap.ui.webc.fiori.ViewSettingsDialog.prototype.sortDescending
     * @type {boolean}
     * @defaultvalue false
     * @public
     */
    sortDescending: boolean;
    /**
     * Keeps recently focused list in order to focus it on next dialog open.
     *
     * @type {object}
     * @private
     */
    _recentlyFocused: List;
    /**
     * Stores settings of the dialog before the initial open.
     *
     * @type {object}
     * @private
     */
    _initialSettings: VSDInternalSettings;
    /**
     * Stores settings of the dialog after confirmation.
     *
     * @type {object}
     * @private
     */
    _confirmedSettings: VSDInternalSettings;
    /**
     * Stores current settings of the dialog.
     *
     * @type {object}
     * @private
     */
    _currentSettings: VSDInternalSettings;
    /**
     * Defnies the current mode of the component.
     *
     * @since 1.0.0-rc.16
     * @private
     */
    _currentMode: ViewSettingsDialogMode;
    /**
     * When in Filter By mode, defines whether we need to show the list of keys, or the list with values.
     *
     * @since 1.0.0-rc.16
     * @private
     */
    _filterStepTwo: boolean;
    /**
     * Defines the list of items against which the user could sort data.
     * <b>Note:</b> If you want to use this slot, you need to import used item: <code>import "@ui5/webcomponents-fiori/dist/SortItem";</code>
     *
     * @name sap.ui.webc.fiori.ViewSettingsDialog.prototype.sortItems
     * @type {sap.ui.webc.fiori.ISortItem[]}
     * @slot sortItems
     * @public
     */
    sortItems: Array<SortItem>;
    /**
     * Defines the <code>filterItems</code> list.
     * <b>Note:</b> If you want to use this slot, you need to import used item: <code>import "@ui5/webcomponents-fiori/dist/FilterItem";</code>
     *
     * @type {sap.ui.webc.fiori.IFilterItem[]}
     * @name sap.ui.webc.fiori.ViewSettingsDialog.prototype.filterItems
     * @slot filterItems
     * @public
     */
    filterItems: Array<FilterItem>;
    _dialog?: Dialog;
    _sortOrder?: List;
    _sortBy?: List;
    static i18nBundle: I18nBundle;
    constructor();
    onBeforeRendering(): void;
    _setAdditionalTexts(): void;
    static onDefine(): Promise<void>;
    get _selectedFilter(): (VSDItem & {
        filterOptions: VSDItem[];
    }) | undefined;
    get shouldBuildSort(): boolean;
    get shouldBuildFilter(): boolean;
    get hasPagination(): boolean;
    get _filterByTitle(): string;
    get _dialogTitle(): string;
    get _okButtonLabel(): string;
    get _cancelButtonLabel(): string;
    get _resetButtonLabel(): string;
    get _ascendingLabel(): string;
    get _descendingLabel(): string;
    get _sortOrderLabel(): string;
    get _filterByLabel(): string;
    get _sortByLabel(): string;
    get _isPhone(): boolean;
    get _sortAscending(): boolean;
    get _title(): string;
    /**
     * Determines disabled state of the <code>Reset</code> button.
     */
    get _disableResetButton(): boolean | undefined;
    get _sortSetttingsAreInitial(): boolean;
    get _filteresAreInitial(): boolean;
    /**
     * Returns the current settings (current state of all lists).
     */
    get _settings(): VSDInternalSettings;
    get initSortByItems(): {
        text: string;
        selected: boolean;
        index: number;
    }[];
    get initSortOrderItems(): {
        text: string;
        selected: boolean;
    }[];
    get expandContent(): boolean;
    get isModeSort(): boolean;
    get isModeFilter(): boolean;
    get showBackButton(): boolean;
    get _sortOrderListDomRef(): List;
    get _sortByList(): List;
    get _dialogDomRef(): Dialog;
    /**
     * Shows the dialog.
     * @public
     * @method
     * @name sap.ui.webc.fiori.ViewSettingsDialog#show
     */
    show(): void;
    _handleModeChange(e: CustomEvent): void;
    _handleFilterValueItemClick(e: CustomEvent<ListItemClickEventDetail>): void;
    _navigateToFilters(): void;
    _changeCurrentFilter(e: CustomEvent<ListItemClickEventDetail>): void;
    /**
     * Closes the dialog.
     */
    close(): void;
    /**
     * Sets focus on recently used control within the dialog.
     */
    _focusRecentlyUsedControl(): void;
    /**
     * Stores current settings as confirmed and fires <code>confirm</code> event.
     */
    _confirmSettings(): void;
    /**
     * Sets current settings to recently confirmed ones and fires <code>cancel</code> event.
     */
    _cancelSettings(): void;
    get eventsParams(): {
        sortOrder: string;
        sortDescending: boolean;
        sortBy: string;
        sortByItem: SortItem;
        filters: VSDFilters;
    };
    get selectedFilters(): VSDFilters;
    /**
     * If the dialog is closed by [ESC] key, do the same as if the <code>Cancel</code> button is pressed.
     *
     * @param {event} evt
     */
    _restoreConfirmedOnEscape(evt: CustomEvent): void;
    /**
     * Resets the control settings to their initial state.
     */
    _resetSettings(): void;
    /**
     * Sets current settings to ones passed as <code>settings</code> argument.
     *
     * @param {Object} settings
     */
    _restoreSettings(settings: VSDInternalSettings): void;
    /**
     * Stores <code>Sort Order</code> list as recently used control and its selected item in current state.
     */
    _onSortOrderChange(e: CustomEvent<ListItemClickEventDetail>): void;
    /**
     * Stores <code>Sort By</code> list as recently used control and its selected item in current state.
     */
    _onSortByChange(e: CustomEvent<ListItemClickEventDetail>): void;
    /**
     * Sets a JavaScript object, as settings to the <code>ui5-view-settings-dialog</code>.
     * This method can be used after the dialog is initially open, as the dialog need to set its initial settings.
     * The <code>ui5-view-settings-dialog</code> throws an event called "before-open", this can be used as trigger point.
     * The object should have the following format:
     * <code>
     *  {sortOrder: "Ascending", sortBy: "Name", filters: [{"Filter 1": ["Some filter 1", "Some filter 2"]}, {"Filter 2": ["Some filter 4"]}]}
     * </code>
     * @param {Object} settings - predefined settings.
     * @param {string} settings.sortOrder - sort order
     * @param {string} settings.sortBy - sort by
     * @param {Array.<Object>} settings.filters - filters
     * @public
     * @method
     * @name sap.ui.webc.fiori.ViewSettingsDialog#setConfirmedSettings
     */
    setConfirmedSettings(settings: VSDSettings): void;
}
export default ViewSettingsDialog;
export type { ViewSettingsDialogConfirmEventDetail, ViewSettingsDialogCancelEventDetail, };
