import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import Dialog from "@ui5/webcomponents/dist/Dialog.js";
declare const BrowserMultiFormatReader: typeof import("@zxing/library/esm5/index.js").BrowserMultiFormatReader;
type BarcodeScannerDialogScanSuccessEventDetail = {
    text: string;
    rawBytes: Uint8Array;
};
type BarcodeScannerDialogScanErrorEventDetail = {
    message: string;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>BarcodeScannerDialog</code> component provides barcode scanning functionality for all devices that support the <code>MediaDevices.getUserMedia()</code> native API.
 * Opening the dialog launches the device camera and scans for known barcode formats.
 * <br>
 * <br>
 * A <code>scanSuccess</code> event fires whenever a barcode is identified
 * and a <code>scanError</code> event fires when the scan failed (for example, due to missing permisions).
 * <br>
 * <br>
 * Internally, the component  uses the zxing-js/library third party OSS.
 *
 * For a list of supported barcode formats, see the <ui5-link target="_blank" href="https://github.com/zxing-js/library">zxing-js/library</ui5-link> documentation.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.BarcodeScannerDialog
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-barcode-scanner-dialog
 * @public
 * @since 1.0.0-rc.15
 */
declare class BarcodeScannerDialog extends UI5Element {
    /**
     * Indicates whether a loading indicator should be displayed in the dialog.
     *
     * @type {boolean}
     * @name sap.ui.webc.fiori.BarcodeScannerDialog.prototype.loading
     * @defaultvalue false
     * @private
     */
    loading: boolean;
    _codeReader: InstanceType<typeof BrowserMultiFormatReader>;
    dialog?: Dialog;
    static i18nBundle: I18nBundle;
    constructor();
    static onDefine(): Promise<void>;
    /**
     * Shows a dialog with the camera videostream. Starts a scan session.
     * @method
     * @name sap.ui.webc.fiori.BarcodeScannerDialog#show
     * @returns {void}
     * @public
     */
    show(): void;
    /**
     * Closes the dialog and the scan session.
     * @method
     * @name sap.ui.webc.fiori.BarcodeScannerDialog#close
     * @returns {void}
     * @public
     */
    close(): void;
    /**
     *  PRIVATE METHODS
     */
    _hasGetUserMedia(): boolean;
    _getUserPermission(): Promise<MediaStream>;
    _getDialog(): Promise<Dialog>;
    _getVideoElement(): Promise<HTMLVideoElement>;
    _showDialog(): Promise<void>;
    _closeDialog(): void;
    _startReader(): void;
    _resetReader(): Promise<void>;
    _decodeFromCamera(): Promise<void>;
    get _cancelButtonText(): string;
    get _busyIndicatorText(): string;
}
export default BarcodeScannerDialog;
export type { BarcodeScannerDialogScanErrorEventDetail, BarcodeScannerDialogScanSuccessEventDetail, };
