import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { I18nText } from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-left.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-right.js";
import FCLLayout from "./types/FCLLayout.js";
import type { LayoutConfiguration } from "./fcl-utils/FCLLayout.js";
declare enum MEDIA {
    PHONE = "phone",
    TABLET = "tablet",
    DESKTOP = "desktop"
}
type ColumnLayout = Array<string | number>;
type FlexibleColumnLayoutLayoutChangeEventDetail = {
    layout: `${FCLLayout}`;
    columnLayout: ColumnLayout;
    startColumnVisible: boolean;
    midColumnVisible: boolean;
    endColumnVisible: boolean;
    arrowUsed: boolean;
    arrowsUsed: boolean;
    resize: boolean;
};
type AccessiblilityTexts = {
    startColumnAccessibleName?: I18nText;
    startArrowContainerAccessibleName?: I18nText;
    startArrowLeftText?: I18nText;
    startArrowRightText?: I18nText;
    midColumnAccessibleName?: I18nText;
    endColumnAccessibleName?: I18nText;
    endArrowContainerAccessibleName?: I18nText;
    endArrowRightText?: I18nText;
    endArrowLeftText?: I18nText;
};
type AccessibilityRoles = {
    startColumnRole?: I18nText;
    midColumnRole?: I18nText;
    endColumnRole?: I18nText;
    startArrowContainerRole?: I18nText;
    endArrowContainerRole?: I18nText;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>FlexibleColumnLayout</code> implements the list-detail-detail paradigm by displaying up to three pages in separate columns.
 * There are several possible layouts that can be changed either with the component API, or by pressing the arrows, displayed between the columns.
 *
 * <h3>Usage</h3>
 *
 * Use this component for applications that need to display several logical levels of related information side by side (e.g. list of items, item, sub-item, etc.).
 * The Component is flexible in a sense that the application can focus the user's attention on one particular column.
 *
 * <h3>Responsive Behavior</h3>
 *
 * The <code>FlexibleColumnLayout</code> automatically displays the maximum possible number of columns based on <code>layout</code> property and the window size.
 * The component would display 1 column for window size smaller than 599px, up to two columns between 599px and 1023px,
 * and 3 columns for sizes bigger than 1023px.
 *
 * <br><br>
 * <h3>Keyboard Handling</h3>
 *
 * <h4>Basic Navigation</h4>
 * <ul>
 * <li>[SPACE, ENTER, RETURN] - If focus is on the layout toggle button (arrow button), once activated, it triggers the associated action (such as expand/collapse the column).</li>
 * <li>This component provides a build in fast navigation group which can be used via <code>F6 / Shift + F6</code> or <code> Ctrl + Alt(Option) + Down /  Ctrl + Alt(Option) + Up</code>.
 * In order to use this functionality, you need to import the following module:
 * <code>import "@ui5/webcomponents-base/dist/features/F6Navigation.js"</code></li>
 * </ul>
 *
 * <h4>Fast Navigation</h4>
 * This component provides a build in fast navigation group which can be used via <code>F6 / Shift + F6</code> or <code> Ctrl + Alt(Option) + Down /  Ctrl + Alt(Option) + Up</code>.
 * In order to use this functionality, you need to import the following module:
 * <code>import "@ui5/webcomponents-base/dist/features/F6Navigation.js"</code>
 * <br><br>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents-fiori/dist/FlexibleColumnLayout.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.FlexibleColumnLayout
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-flexible-column-layout
 * @public
 * @since 1.0.0-rc.8
 */
declare class FlexibleColumnLayout extends UI5Element {
    /**
    * Defines the columns layout and their proportion.
    * <br><br>
    * <b>Note:</b> The layout also depends on the screen size - one column for screens smaller than 599px,
    * two columns between 599px and 1023px and three columns for sizes bigger than 1023px.
    * <br><br>
    * <b>For example:</b> layout=<code>TwoColumnsStartExpanded</code> means the layout will display up to two columns
    * in 67%/33% proportion.
    * @type {sap.ui.webc.fiori.types.FCLLayout}
    * @defaultvalue "OneColumn"
    * @name sap.ui.webc.fiori.FlexibleColumnLayout.prototype.layout
    * @public
    */
    layout: `${FCLLayout}`;
    /**
    * Defines the visibility of the arrows,
    * used for expanding and shrinking the columns.
    *
    * @type {boolean}
    * @defaultvalue false
    * @name sap.ui.webc.fiori.FlexibleColumnLayout.prototype.hideArrows
    * @public
    * @since 1.0.0-rc.15
    */
    hideArrows: boolean;
    /**
    * An object of strings that defines several additional accessibility texts for even further customization.
    *
    * It supports the following fields:
    *  - <code>startColumnAccessibleName</code>: the accessibility name for the <code>startColumn</code> region
    *  - <code>midColumnAccessibleName</code>: the accessibility name for the <code>midColumn</code> region
    *  - <code>endColumnAccessibleName</code>: the accessibility name for the <code>endColumn</code> region
    *  - <code>startArrowLeftText</code>: the text that the first arrow (between the <code>begin</code> and <code>mid</code> columns) will have when pointing to the left
    *  - <code>startArrowRightText</code>: the text that the first arrow (between the <code>begin</code> and <code>mid</code> columns) will have when pointing to the right
    *  - <code>endArrowLeftText</code>: the text that the second arrow (between the <code>mid</code> and <code>end</code> columns) will have when pointing to the left
    *  - <code>endArrowRightText</code>: the text that the second arrow (between the <code>mid</code> and <code>end</code> columns) will have when pointing to the right
    *  - <code>startArrowContainerAccessibleName</code>: the text that the first arrow container (between the <code>begin</code> and <code>mid</code> columns) will have as <code>aria-label</code>
    *  - <code>endArrowContainerAccessibleName</code>: the text that the second arrow container (between the <code>mid</code> and <code>end</code> columns) will have as <code>aria-label</code>
    *
    * @type {object}
    * @name sap.ui.webc.fiori.FlexibleColumnLayout.prototype.accessibilityTexts
    * @public
    * @since 1.0.0-rc.11
    */
    accessibilityTexts: AccessiblilityTexts;
    /**
    * An object of strings that defines additional accessibility roles for further customization.
    *
    * It supports the following fields:
    *  - <code>startColumnRole</code>: the accessibility role for the <code>startColumn</code>
    *  - <code>startArrowContainerRole</code>: the accessibility role for the first arrow container (between the <code>begin</code> and <code>mid</code> columns)
    *  - <code>midColumnRole</code>: the accessibility role for the <code>midColumn</code>
    *  - <code>endArrowContainerRole</code>: the accessibility role for the second arrow container (between the <code>mid</code> and <code>end</code> columns)
    *  - <code>endColumnRole</code>: the accessibility role for the <code>endColumn</code>
    *
    * @type {object}
    * @public
    * @name sap.ui.webc.fiori.FlexibleColumnLayout.prototype.accessibilityRoles
    * @since 1.1.0
    */
    accessibilityRoles: AccessibilityRoles;
    /**
    * Defines the component width in px.
    *
    * @type {sap.ui.webc.base.types.Float}
    * @defaultvalue 0
    * @private
    */
    _width: number;
    /**
    * Defines the effective columns layout,
    * based on both the <code>layout</code> property and the screen size.
    * Example: [67%, 33%, 0], [25%, 50%, 25%], etc.
    *
    * @type {object}
    * @defaultvalue undefined
    * @private
    */
    _columnLayout?: ColumnLayout;
    /**
    * Defines the visible columns count - 1, 2 or 3.
    *
    * @type {sap.ui.webc.base.types.Integer}
    * @defaultvalue 1
    * @private
    */
    _visibleColumns: number;
    /**
    * Allows the user to replace the whole layouts configuration
    *
    * @type {object}
    * @private
    * @sap-restricted
    */
    _layoutsConfiguration?: LayoutConfiguration;
    /**
    * Defines the content in the start column.
    * @type {HTMLElement}
    * @slot
    * @name sap.ui.webc.fiori.FlexibleColumnLayout.prototype.startColumn
    * @public
    */
    startColumn: Array<HTMLElement>;
    /**
    * Defines the content in the middle column.
    * @type {HTMLElement}
    * @slot
    * @name sap.ui.webc.fiori.FlexibleColumnLayout.prototype.midColumn
    * @public
    */
    midColumn: Array<HTMLElement>;
    /**
    * Defines the content in the end column.
    * @type {HTMLElement}
    * @slot
    * @name sap.ui.webc.fiori.FlexibleColumnLayout.prototype.endColumn
    * @public
    */
    endColumn: Array<HTMLElement>;
    initialRendering: boolean;
    _handleResize: () => void;
    static i18nBundle: I18nBundle;
    _prevLayout: `${FCLLayout}` | null;
    constructor();
    static onDefine(): Promise<void>;
    static get ANIMATION_DURATION(): 0 | 560;
    onEnterDOM(): void;
    onExitDOM(): void;
    onAfterRendering(): void;
    handleInitialRendering(): void;
    handleResize(): void;
    startArrowClick(): void;
    endArrowClick(): void;
    arrowClick(options: {
        start: boolean;
        end: boolean;
    }): void;
    updateLayout(): void;
    syncLayout(): void;
    toggleColumns(): void;
    toggleColumn(column: string): void;
    columnResizeHandler: (e: Event) => void;
    nextLayout(layout: `${FCLLayout}`, arrowsInfo: {
        start: boolean;
        end: boolean;
    }): undefined;
    nextColumnLayout(layout: `${FCLLayout}`): string[];
    calcVisibleColumns(colLayout: ColumnLayout): number;
    fireLayoutChange(arrowUsed: boolean, resize: boolean): void;
    /**
     * Checks if a column is hidden based on its width.
     */
    private _isColumnHidden;
    /**
    * Returns the current column layout, based on both the <code>layout</code> property and the screen size.
    * <br><br>
    * <b>For example:</b> ["67%", "33%", 0], ["100%", 0, 0], ["25%", "50%", "25%"], etc,
    * where the numbers represents the width of the start, middle and end columns.
    * @readonly
    * @type {array}
    * @defaultvalue ["100%", 0, 0]
    * @name sap.ui.webc.fiori.FlexibleColumnLayout.prototype.columnLayout
    * @public
    */
    get columnLayout(): ColumnLayout | undefined;
    /**
    * Returns if the <code>start</code> column is visible.
    * @readonly
    * @defaultvalue true
    * @type {boolean}
    * @name sap.ui.webc.fiori.FlexibleColumnLayout.prototype.startColumnVisible
    * @public
    */
    get startColumnVisible(): boolean;
    /**
    * Returns if the <code>middle</code> column is visible.
    * @readonly
    * @type {boolean}
    * @defaultvalue false
    * @name sap.ui.webc.fiori.FlexibleColumnLayout.prototype.midColumnVisible
    * @public
    */
    get midColumnVisible(): boolean;
    /**
    * Returns if the <code>end</code> column is visible.
    * @readonly
    * @type {boolean}
    * @defaultvalue false
    * @name sap.ui.webc.fiori.FlexibleColumnLayout.prototype.endColumnVisible
    * @public
    */
    get endColumnVisible(): boolean;
    /**
    * Returns the number of currently visible columns.
    * @readonly
    * @type {sap.ui.webc.base.types.Integer}
    * @defaultvalue 1
    * @name sap.ui.webc.fiori.FlexibleColumnLayout.prototype.visibleColumns
    * @public
    */
    get visibleColumns(): number;
    get classes(): {
        root: {
            "ui5-fcl-root": boolean;
        };
        columns: {
            start: {
                "ui5-fcl-column": boolean;
                "ui5-fcl-column-animation": boolean;
                "ui5-fcl-column--start": boolean;
            };
            middle: {
                "ui5-fcl-column": boolean;
                "ui5-fcl-column-animation": boolean;
                "ui5-fcl-column--middle": boolean;
            };
            end: {
                "ui5-fcl-column": boolean;
                "ui5-fcl-column-animation": boolean;
                "ui5-fcl-column--end": boolean;
            };
        };
    };
    get styles(): {
        arrowsContainer: {
            start: {
                display: string;
            };
            end: {
                display: string;
            };
        };
        arrows: {
            start: {
                display: string;
                transform: string;
            };
            end: {
                display: string;
                transform: string;
            };
        };
    };
    get startColumnWidth(): string | number;
    get midColumnWidth(): string | number;
    get endColumnWidth(): string | number;
    get showStartSeparator(): boolean;
    get showEndSeparator(): boolean;
    get showStartArrow(): boolean;
    get showEndArrow(): boolean;
    get startArrowVisibility(): boolean;
    get endArrowVisibility(): boolean;
    get startArrowDirection(): string | null;
    get endArrowDirection(): string | null;
    get effectiveArrowsInfo(): {
        visible: boolean;
        dir: string | null;
        separator?: boolean | undefined;
    }[];
    get media(): MEDIA;
    get widthDOM(): number;
    get startColumnDOM(): HTMLElement;
    get midColumnDOM(): HTMLElement;
    get endColumnDOM(): HTMLElement;
    get accStartColumnText(): string | I18nText;
    get accMiddleColumnText(): string | I18nText;
    get accEndColumnText(): string | I18nText;
    get accStartArrowContainerText(): I18nText | undefined;
    get accEndArrowContainerText(): I18nText | undefined;
    get accStartColumnRole(): I18nText | "region" | undefined;
    get accMiddleColumnRole(): I18nText | "region" | undefined;
    get accEndColumnRole(): I18nText | "region" | undefined;
    get accStartArrowContainerRole(): I18nText | undefined;
    get accEndArrowContainerRole(): I18nText | undefined;
    get _effectiveLayoutsByMedia(): LayoutConfiguration;
    get _accAttributes(): {
        columns: {
            start: {
                role: string | I18nText | undefined;
                ariaHidden: true | undefined;
            };
            middle: {
                role: string | I18nText | undefined;
                ariaHidden: true | undefined;
            };
            end: {
                role: string | I18nText | undefined;
                ariaHidden: true | undefined;
            };
        };
    };
    get accStartArrowText(): string | I18nText;
    get accEndArrowText(): string | I18nText;
}
export default FlexibleColumnLayout;
export type { MEDIA, FlexibleColumnLayoutLayoutChangeEventDetail, };
