import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import IllustrationMessageSize from "./types/IllustrationMessageSize.js";
import IllustrationMessageType from "./types/IllustrationMessageType.js";
import "./illustrations/BeforeSearch.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * An IllustratedMessage is a recommended combination of a solution-oriented message, an engaging
 * illustration, and conversational tone to better communicate an empty or a success state than just show
 * a message alone.
 *
 * Each illustration has default internationalised title and subtitle texts. Also they can be managed with
 * <code>titleText</code> and <code>subtitleText</code> properties.
 *
 * To display the desired illustration, use the <code>name</code> property, where you can find the list of all available illustrations.
 * <br><br>
 * <b>Note:</b> By default the “BeforeSearch” illustration is loaded. To use other illustrations, make sure you import them in addition, for example:
 * <br>
 * <code>import "@ui5/webcomponents-fiori/dist/illustrations/NoData.js"</code>
 * <br>
 * <b>Note:</b> Illustrations starting with the “Tnt” prefix are part of another illustration set. For example to use the “TntSuccess” illustration, add the following import::
 * <br>
 * <code>import "@ui5/webcomponents-fiori/dist/illustrations/tnt/Success.js"</code>
 *
 * <h3>Structure</h3>
 * The IllustratedMessage consists of the following elements, which are displayed below each other in the following order:
 * <br>
 * <ul>
 * <li>Illustration</li>
 * <li>Title</li>
 * <li>Subtitle</li>
 * <li>Actions</li>
 * </ul>
 *
 * <h3>Usage</h3>
 * <code>ui5-illustrated-message</code> is meant to be used inside container component, for example a <code>ui5-card</code>,
 * a <code>ui5-dialog</code> or a <code>ui5-page</code>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents-fiori/dist/IllustratedMessage.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.IllustratedMessage
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-illustrated-message
 * @public
 * @since 1.0.0-rc.15
 */
declare class IllustratedMessage extends UI5Element {
    /**
    * Defines the illustration name that will be displayed in the component.
    * <br><br>
    * <b>Note:</b> By default the <code>BeforeSearch</code> illustration is loaded.
    * <br>
    * When using an illustration type, other than the default, it should be loaded in addition:
    * <br>
    * <code>import "@ui5/webcomponents-fiori/dist/illustrations/NoData.js";</code>
    * <br><br>
    * <b>Note:</b> TNT illustrations cointain <code>Tnt</code> prefix in their name.
    * You can import them removing the <code>Tnt</code> prefix like this:
    * <br>
    * <code>import "@ui5/webcomponents-fiori/dist/illustrations/tnt/SessionExpired.js";</code>
    * @type {sap.ui.webc.fiori.types.IllustrationMessageType}
    * @defaultvalue "BeforeSearch"
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.name
    * @public
    */
    name: `${IllustrationMessageType}`;
    /**
    * Determines which illustration breakpoint variant is used.
    * <br><br>
    *
    * As <code>IllustratedMessage</code> adapts itself around the <code>Illustration</code>, the other
    * elements of the component are displayed differently on the different breakpoints/illustration sizes.
    *
    * @type {sap.ui.webc.fiori.types.IllustrationMessageSize}
    * @defaultvalue "Auto"
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.size
    * @public
    * @since 1.5.0
    */
    size: `${IllustrationMessageSize}`;
    /**
    * Defines the subtitle of the component.
    * <br><br>
    * <b>Note:</b> Using this property, the default subtitle text of illustration will be overwritten.
    * <br><br>
    * <b>Note:</b> Using <code>subtitle</code> slot, the default of this property will be overwritten.
    * @type {string}
    * @defaultvalue ""
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.subtitleText
    * @public
    */
    subtitleText: string;
    /**
    * Defines the title of the component.
    * <br><br>
    * <b>Note:</b> Using this property, the default title text of illustration will be overwritten.
    * @type {string}
    * @defaultvalue ""
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.titleText
    * @public
    */
    titleText: string;
    /**
    * Receives id(or many ids) of the elements that label the component.
    *
    * @type {string}
    * @defaultvalue ""
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.accessibleNameRef
    * @public
    * @since 1.7.0
    */
    accessibleNameRef: string;
    /**
    * Illustration breakpoint variant for the <code>Spot</code> size.
    *
    * @private
    * @type {String}
    * @since 1.9.0
    */
    spotSvg: string;
    /**
    * Illustration breakpoint variant for the <code>Scene</code> size.
    *
    * @private
    * @type {String}
    * @since 1.9.0
    */
    sceneSvg: string;
    /**
    * Illustration breakpoint variant for the <code>Dialog</code> size.
    *
    * @private
    * @type {String}
    * @since 1.9.0
    */
    dialogSvg: string;
    /**
    * Determinates what is the current media of the component based on its width.
    * @private
    */
    media: string;
    /**
    * Defines the title of the component.
    * <br><br>
    * <b>Note:</b> Using this slot, the default title text of illustration and the value of <code>title</code> property will be overwritten.
    * @type {HTMLElement}
    * @slot title
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.title
    * @public
    * @since 1.7.0
    */
    title: Array<HTMLElement> & string;
    /**
    * Defines the subtitle of the component.
    * <br><br>
    * <b>Note:</b> Using this slot, the default subtitle text of illustration and the value of <code>subtitleText</code> property will be overwritten.
    * @type {HTMLElement}
    * @slot subtitle
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.subtitle
    * @public
    * @since 1.0.0-rc.16
    */
    subtitle: Array<HTMLElement>;
    /**
    * Defines the component actions.
    * @type {sap.ui.webc.main.IButton[]}
    * @slot actions
    * @name sap.ui.webc.fiori.IllustratedMessage.prototype.default
    * @public
    */
    actions: Array<HTMLElement>;
    illustrationTitle?: string;
    illustrationSubtitle?: string;
    static i18nBundle: I18nBundle;
    _lastKnownOffsetWidthForMedia: Record<string, number>;
    _lastKnownOffsetHeightForMedia: Record<string, number>;
    _lastKnownMedia: string;
    _handleResize: ResizeObserverCallback;
    constructor();
    static onDefine(): Promise<void>;
    static get BREAKPOINTS(): {
        DIALOG: number;
        SPOT: number;
        BASE: number;
    };
    static get BREAKPOINTS_HEIGHT(): {
        DIALOG: number;
        SPOT: number;
        BASE: number;
    };
    static get MEDIA(): {
        BASE: string;
        SPOT: string;
        DIALOG: string;
        SCENE: string;
    };
    onBeforeRendering(): Promise<void>;
    onEnterDOM(): void;
    onExitDOM(): void;
    handleResize(): void;
    _applyMedia(heightChange?: boolean): void;
    _setSVGAccAttrs(): void;
    _adjustHeightToFitContainer(): void;
    onAfterRendering(): void;
    /**
     * Modifies the IM styles in accordance to the `size` property's value.
     * Note: The resize handler has no effect when size is different than "Auto".
     * @private
     * @since 1.5.0
     */
    _handleCustomSize(): void;
    get ariaLabelText(): string | undefined;
    get effectiveIllustration(): string;
    get hasFormattedSubtitle(): boolean;
    get hasFormattedTitle(): boolean;
    get effectiveTitleText(): string | undefined;
    get effectiveSubitleText(): string | undefined;
    get hasTitle(): boolean;
    get hasSubtitle(): boolean;
    get hasActions(): boolean;
    isValidIllustration(currentIllustration: `${IllustrationMessageType}`): boolean;
}
export default IllustratedMessage;
