import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import "@ui5/webcomponents-icons/dist/background.js";
import type { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import MediaGalleryItemLayout from "./types/MediaGalleryItemLayout.js";
/**
 * @class
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-media-gallery-item</code> web component represents the items displayed in the
 * <code>ui5-media-gallery</code> web component.
 * <br><br>
 * <b>Note:</b> <code>ui5-media-gallery-item</code> is not supported when used outside of <code>ui5-media-gallery</code>.
 * <br><br>
 *
 * <h3>Keyboard Handling</h3>
 * The <code>ui5-media-gallery</code> provides advanced keyboard handling.
 * When focused, the user can use the following keyboard
 * shortcuts in order to perform a navigation:
 * <br>
 * <ul>
 * <li>[SPACE/ENTER/RETURN] - Trigger <code>ui5-click</code> event</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 * <code>import "@ui5/webcomponents-fiori/dist/MediaGalleryItem.js";</code> (comes with <code>ui5-media-gallery</code>)
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.MediaGalleryItem
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-media-gallery-item
 * @public
 * @implements sap.ui.webc.fiori.IMediaGalleryItem
 * @since 1.1.0
 */
declare class MediaGalleryItem extends UI5Element implements ITabbable {
    /**
     * Defines the selected state of the component.
     *
     * @type {boolean}
     * @name sap.ui.webc.fiori.MediaGalleryItem.prototype.selected
     * @defaultvalue false
     * @public
     */
    selected: boolean;
    /**
     * Defines whether the component is in disabled state.
     *
     * @type {boolean}
     * @name sap.ui.webc.fiori.MediaGalleryItem.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Determines the layout of the item container.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>Square</code></li>
     * <li><code>Wide</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.fiori.types.MediaGalleryItemLayout}
     * @name sap.ui.webc.fiori.MediaGalleryItem.prototype.layout
     * @defaultvalue "Square"
     * @public
     */
    layout: `${MediaGalleryItemLayout}`;
    /**
     * @private
     */
    _interactive: boolean;
    /**
     * @private
     */
    _square: boolean;
    /**
     * @private
     */
    _contentImageNotFound: boolean;
    /**
     * @private
     */
    _thumbnailNotFound: boolean;
    /**
     * @private
     */
    _thumbnailDesign: boolean;
    /**
     * @private
     */
    focused: boolean;
    /**
     * @private
     */
    _tabIndex: string;
    /**
     * @private
     */
    contentHeight: string;
    /**
     * Defines the content of the component.
     *
     * @type {HTMLElement}
     * @name sap.ui.webc.fiori.MediaGalleryItem.prototype.default
     * @slot content
     * @public
     */
    content: Array<HTMLElement>;
    /**
     * Defines the content of the thumbnail.
     *
     * @type {HTMLElement}
     * @name sap.ui.webc.fiori.MediaGalleryItem.prototype.thumbnail
     * @slot thumbnail
     * @public
     */
    thumbnail: Array<HTMLElement>;
    _monitoredThumbnail: HTMLElement | null;
    _monitoredContent: HTMLElement | null;
    constructor();
    onEnterDOM(): void;
    get _thumbnail(): HTMLElement | null;
    get _content(): HTMLElement | null;
    get _isThubmnailAvailable(): boolean | null;
    get _isContentAvailable(): boolean | null;
    get _useThumbnail(): boolean | null;
    get _useContent(): boolean | null;
    get effectiveTabIndex(): string | undefined;
    get _showBackgroundIcon(): boolean;
    get styles(): {
        wrapper: {
            height: string;
        };
    };
    get _role(): "button" | undefined;
    onBeforeRendering(): void;
    _monitorLoadingError(): void;
    _attachListeners(element: HTMLImageElement, callback: (image: HTMLImageElement) => void): true | undefined;
    _updateContentImageLoaded(image: HTMLImageElement): void;
    _updateThumbnailLoaded(image: HTMLImageElement): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    _onfocusout(): void;
    _onfocusin(): void;
    _fireItemClick(): void;
}
export default MediaGalleryItem;
