import NotificationListItemBase from "./NotificationListItemBase.js";
import type NotificationListItem from "./NotificationListItem.js";
import "@ui5/webcomponents-icons/dist/navigation-right-arrow.js";
import "@ui5/webcomponents-icons/dist/overflow.js";
import "@ui5/webcomponents-icons/dist/decline.js";
import type { NotificationListItemBaseCloseEventDetail as NotificationListGroupItemCloseEventDetail } from "./NotificationListItemBase.js";
type NotificationListGroupItemToggleEventDetail = {
    item: NotificationListGroupItem;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-li-notification-group</code> is a special type of list item,
 * that unlike others can group items within self, usually <code>ui5-li-notification</code> items.
 * <br>
 *
 * The component consists of:
 * <ul>
 * <li><code>Toggle</code> button to expand and collapse the group</li>
 * <li><code>Priority</code> icon to display the priority of the group</li>
 * <li><code>TitleText</code> to entitle the group</li>
 * <li>Custom actions - with the use of <code>ui5-notification-action</code></li>
 * <li>Items of the group</li>
 * </ul>
 *
 * <h3>Usage</h3>
 * The component can be used in a standard <code>ui5-list</code>.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-li-notification-group</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>title-text - Used to style the titleText of the notification list group item</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/NotificationListGroupItem.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents/dist/NotificationAction.js";</code> (optional)
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.NotificationListGroupItem
 * @extends sap.ui.webc.fiori.NotificationListItemBase
 * @tagname ui5-li-notification-group
 * @since 1.0.0-rc.8
 * @appenddocs sap.ui.webc.fiori.NotificationAction
 * @implements sap.ui.webc.main.IListItem
 * @public
 */
declare class NotificationListGroupItem extends NotificationListItemBase {
    /**
     * Defines if the group is collapsed or expanded.
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.fiori.NotificationListGroupItem.prototype.collapsed
     * @public
     */
    collapsed: boolean;
    /**
     * Defines if the items <code>counter</code> would be displayed.
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.fiori.NotificationListGroupItem.prototype.showCounter
     * @public
     */
    showCounter: boolean;
    /**
     * Defines the items of the <code>ui5-li-notification-group</code>,
     * usually <code>ui5-li-notification</code> items.
     *
     * @type {sap.ui.webc.fiori.INotificationListItem[]}
     * @slot items
     * @name sap.ui.webc.fiori.NotificationListGroupItem.prototype.default
     * @public
     */
    items: Array<NotificationListItem>;
    onBeforeRendering(): void;
    /**
     * Clears child items busy state to show a single busy over the entire group,
     * instead of multiple BusyIndicator instances
     */
    clearChildBusyIndicator(): void;
    get itemsCount(): number;
    get overflowBtnAccessibleName(): string;
    get closeBtnAccessibleName(): string;
    get toggleBtnAccessibleName(): string;
    get priorityText(): string;
    get accInvisibleText(): string;
    get readText(): string;
    get groupText(): string;
    get counterText(): string;
    get ariaLabelledBy(): string;
    get _ariaExpanded(): boolean;
    /**
     * Event handlers
     *
     */
    _onBtnToggleClick(): void;
}
export default NotificationListGroupItem;
export type { NotificationListGroupItemToggleEventDetail, NotificationListGroupItemCloseEventDetail, };
