import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import WrappingType from "@ui5/webcomponents/dist/types/WrappingType.js";
import NotificationListItemBase from "./NotificationListItemBase.js";
import "@ui5/webcomponents-icons/dist/overflow.js";
import "@ui5/webcomponents-icons/dist/decline.js";
import type { NotificationListItemBaseCloseEventDetail as NotificationListItemCloseEventDetail } from "./NotificationListItemBase.js";
type NotificationListItemPressEventDetail = {
    item: NotificationListItem;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-li-notification</code> is a type of list item, meant to display notifications.
 * <br>
 *
 * The component has a rich set of various properties that allows the user to set <code>avatar</code>, <code>titleText</code>, descriptive <code>content</code>
 * and <code>footnotes</code> to fully describe a notification.
 * <br>
 *
 * The user can:
 * <ul>
 * <li>display a <code>Close</code> button</li>
 * <li>can control whether the <code>titleText</code> and <code>description</code> should wrap or truncate
 * and display a <code>ShowMore</code> button to switch between less and more information</li>
 * <li>add custom actions by using the <code>ui5-notification-action</code> component</li>
 * </ul>
 *
 * <h3>Usage</h3>
 * The component can be used in a standard <code>ui5-list</code>.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-li-notification</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>title-text - Used to style the titleText of the notification list item</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/NotificationListItem.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents/dist/NotificationAction.js";</code> (optional)
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.NotificationListItem
 * @extends sap.ui.webc.fiori.NotificationListItemBase
 * @tagname ui5-li-notification
 * @appenddocs sap.ui.webc.fiori.NotificationAction
 * @since 1.0.0-rc.8
 * @implements sap.ui.webc.fiori.INotificationListItem, sap.ui.webc.main.IListItem
 * @public
 */
declare class NotificationListItem extends NotificationListItemBase {
    /**
    * Defines if the <code>titleText</code> and <code>description</code> should wrap,
    * they truncate by default.
    *
    * <br><br>
    * <b>Note:</b> by default the <code>titleText</code> and <code>description</code>,
    * and a <code>ShowMore/Less</code> button would be displayed.
    * @type {sap.ui.webc.main.types.WrappingType}
    * @defaultvalue "None"
    * @public
    * @name sap.ui.webc.fiori.NotificationListItem.prototype.wrappingType
    * @since 1.0.0-rc.15
    */
    wrappingType: `${WrappingType}`;
    /**
    * Defines the state of the <code>titleText</code> and <code>description</code>,
    * if less or more information is displayed.
    * @private
    */
    _showMorePressed: boolean;
    /**
    * Defines the visibility of the <code>showMore</code> button.
    * @private
    */
    _showMore: boolean;
    /**
    * Defines the avatar, displayed in the <code>ui5-li-notification</code>.
    *
    * <br><br>
    * <b>Note:</b> Consider using the <code>ui5-avatar</code> to display icons, initials or images.
    * <br>
    * <b>Note:</b>In order to be complaint with the UX guidlines and for best experience,
    * we recommend using avatars with 2rem X 2rem in size (32px X 32px). In case you are using the <code>ui5-avatar</code>
    * you can set its <code>size</code> property to <code>XS</code> to get the required size - <code>&lt;ui5-avatar size="XS">&lt;/ui5-avatar></code>.
    *
    * @type {sap.ui.webc.main.IAvatar}
    * @slot
    * @public
    * @name sap.ui.webc.fiori.NotificationListItem.prototype.avatar
    */
    avatar: Array<HTMLElement>;
    /**
    * Defines the elements, displayed in the footer of the of the component.
    * @type {HTMLElement[]}
    * @slot
    * @public
    * @name sap.ui.webc.fiori.NotificationListItem.prototype.footnotes
    */
    footnotes: Array<HTMLElement>;
    /**
    * Defines the content of the <code>ui5-li-notification</code>,
    * usually a description of the notification.
    *
    * <br><br>
    * <b>Note:</b> Although this slot accepts HTML Elements, it is strongly recommended that you only use text in order to preserve the intended design.
    *
    * @type {Node[]}
    * @slot description
    * @public
    * @name sap.ui.webc.fiori.NotificationListItem.prototype.default
    */
    description: Array<Node>;
    _titleTextOverflowHeight: number;
    _descOverflowHeight: number;
    _onResizeBound: ResizeObserverCallback;
    constructor();
    onEnterDOM(): void;
    onExitDOM(): void;
    get hasDesc(): boolean;
    get hasFootNotes(): boolean;
    get showMoreText(): string;
    get overflowBtnAccessibleName(): string;
    get closeBtnAccessibleName(): string;
    get hideShowMore(): true | undefined;
    get descriptionDOM(): HTMLElement | null;
    get titleTextDOM(): HTMLElement | null;
    get titleTextHeight(): number;
    get descriptionHeight(): number;
    get titleTextOverflows(): boolean;
    get descriptionOverflows(): boolean;
    get footerItems(): {
        slotName: any;
        showDivider: boolean;
    }[];
    get ariaLabelledBy(): string;
    get priorityText(): string;
    get accInvisibleText(): string;
    /**
     * Event handlers
     */
    _onclick(e: MouseEvent): void;
    _onShowMoreClick(e: MouseEvent): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    /**
     * Private
     */
    fireItemPress(e: Event): void;
    onResize(): void;
}
export default NotificationListItem;
export type { NotificationListItemPressEventDetail, NotificationListItemCloseEventDetail, };
