import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import ItemNavigation from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import type ProductSwitchItem from "./ProductSwitchItem.js";
/**
 * @class
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-product-switch</code> is an SAP Fiori specific web component that is used in <code>ui5-shellbar</code>
 * and allows the user to easily switch between products.
 * <br><br>
 *
 * <h3>Keyboard Handling</h3>
 * The <code>ui5-product-switch</code> provides advanced keyboard handling.
 * When focused, the user can use the following keyboard
 * shortcuts in order to perform a navigation:
 * <br>
 * <ul>
 * <li>[TAB] - Move focus to the next interactive element after the <code>ui5-product-switch</code></li>
 * <li>[UP/DOWN] - Navigates up and down the items </li>
 * <li>[LEFT/RIGHT] - Navigates left and right the items</li>
 * </ul>
 * <br>
 * <br>
 *
 * <h3>ES6 Module Import</h3>
 * <code>import "@ui5/webcomponents-fiori/dist/ProductSwitch.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents-fiori/dist/ProductSwitchItem.js";</code> (for <code>ui5-product-switch-item</code>)
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.ProductSwitch
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-product-switch
 * @appenddocs sap.ui.webc.fiori.ProductSwitchItem
 * @public
 * @since 1.0.0-rc.5
 */
declare class ProductSwitch extends UI5Element {
    constructor();
    /**
     * Indicates how many columns are displayed.
     * @private
     */
    desktopColumns?: number;
    /**
     * Defines the items of the <code>ui5-product-switch</code>.
     *
     * @type {sap.ui.webc.fiori.IProductSwitchItem[]}
     * @name sap.ui.webc.fiori.ProductSwitch.prototype.default
     * @slot items
     * @public
     */
    items: Array<ProductSwitchItem>;
    _itemNavigation: ItemNavigation;
    _currentIndex: number;
    _rowSize: number;
    _handleResizeBound: ResizeObserverCallback;
    static i18nBundle: I18nBundle;
    static get ROW_MIN_WIDTH(): {
        ONE_COLUMN: number;
        THREE_COLUMN: number;
    };
    static onDefine(): Promise<void>;
    get _ariaLabelText(): string;
    onEnterDOM(): void;
    onExitDOM(): void;
    onBeforeRendering(): void;
    _handleResize(): void;
    handleProductSwitchItemClick(e: MouseEvent): void;
    _onfocusin(e: FocusEvent): void;
    _setRowSize(size: number): void;
    _onkeydown(e: KeyboardEvent): void;
    _handleDown(e: KeyboardEvent): void;
    _handleUp(e: KeyboardEvent): void;
}
export default ProductSwitch;
