var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import litRender from "@ui5/webcomponents-base/dist/renderer/LitRenderer.js";
import { isSpace, isEnter, isSpaceShift } from "@ui5/webcomponents-base/dist/Keys.js";
import Icon from "@ui5/webcomponents/dist/Icon.js";
import property from "@ui5/webcomponents-base/dist/decorators/property.js";
import event from "@ui5/webcomponents-base/dist/decorators/event.js";
import customElement from "@ui5/webcomponents-base/dist/decorators/customElement.js";
import ProductSwitchItemTemplate from "./generated/templates/ProductSwitchItemTemplate.lit.js";
// Styles
import ProductSwitchItemCss from "./generated/themes/ProductSwitchItem.css.js";
/**
 * @class
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-product-switch-item</code> web component represents the items displayed in the
 * <code>ui5-product-switch</code> web component.
 * <br><br>
 * <b>Note:</b> <code>ui5-product-switch-item</code> is not supported when used outside of <code>ui5-product-switch</code>.
 * <br><br>
 *
 * <h3>Keyboard Handling</h3>
 * The <code>ui5-product-switch</code> provides advanced keyboard handling.
 * When focused, the user can use the following keyboard
 * shortcuts in order to perform a navigation:
 * <br>
 * <ul>
 * <li>[SPACE/ENTER/RETURN] - Trigger <code>ui5-click</code> event</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 * <code>import "@ui5/webcomponents-fiori/dist/ProductSwitchItem.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.ProductSwitchItem
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-product-switch-item
 * @public
 * @implements sap.ui.webc.fiori.IProductSwitchItem
 * @since 1.0.0-rc.5
 */
let ProductSwitchItem = class ProductSwitchItem extends UI5Element {
    constructor() {
        super();
        this._deactivate = () => {
            if (this.active) {
                this.active = false;
            }
        };
    }
    onEnterDOM() {
        document.addEventListener("mouseup", this._deactivate);
    }
    onExitDOM() {
        document.removeEventListener("mouseup", this._deactivate);
    }
    _onmousedown() {
        this.active = true;
    }
    _onkeydown(e) {
        if (isSpace(e) || isEnter(e)) {
            this.active = true;
        }
        if (isSpace(e)) {
            e.preventDefault();
        }
        if (isEnter(e)) {
            this._fireItemClick();
        }
    }
    _onkeyup(e) {
        if (isSpace(e) || isEnter(e)) {
            this.active = false;
        }
        if (isSpace(e)) {
            if (isSpaceShift(e)) {
                e.stopPropagation();
            }
            this._fireItemClick();
        }
    }
    _onfocusout() {
        this.active = false;
        this.focused = false;
    }
    _onfocusin(e) {
        this.focused = true;
        this.fireEvent("_focused", e);
    }
    _fireItemClick() {
        this.fireEvent("click", { item: this });
    }
};
__decorate([
    property()
], ProductSwitchItem.prototype, "titleText", void 0);
__decorate([
    property()
], ProductSwitchItem.prototype, "subtitleText", void 0);
__decorate([
    property()
], ProductSwitchItem.prototype, "icon", void 0);
__decorate([
    property({ defaultValue: "_self" })
], ProductSwitchItem.prototype, "target", void 0);
__decorate([
    property()
], ProductSwitchItem.prototype, "targetSrc", void 0);
__decorate([
    property({ type: Boolean })
], ProductSwitchItem.prototype, "active", void 0);
__decorate([
    property({ type: Boolean })
], ProductSwitchItem.prototype, "focused", void 0);
__decorate([
    property({ type: Boolean })
], ProductSwitchItem.prototype, "selected", void 0);
__decorate([
    property({ defaultValue: "-1", noAttribute: true })
], ProductSwitchItem.prototype, "_tabIndex", void 0);
ProductSwitchItem = __decorate([
    customElement({
        tag: "ui5-product-switch-item",
        renderer: litRender,
        styles: ProductSwitchItemCss,
        template: ProductSwitchItemTemplate,
        dependencies: [Icon],
    })
    /**
     * Fired when the <code>ui5-product-switch-item</code> is activated either with a
     * click/tap or by using the Enter or Space key.
     *
     * @event sap.ui.webc.fiori.ProductSwitchItem#click
     * @public
     */
    ,
    event("click"),
    event("_focused")
], ProductSwitchItem);
ProductSwitchItem.define();
export default ProductSwitchItem;
//# sourceMappingURL=ProductSwitchItem.js.map