import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ListSelectionChangeEventDetail } from "@ui5/webcomponents/dist/List.js";
import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import Popover from "@ui5/webcomponents/dist/Popover.js";
import Button from "@ui5/webcomponents/dist/Button.js";
import type Input from "@ui5/webcomponents/dist/Input.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import "@ui5/webcomponents-icons/dist/search.js";
import "@ui5/webcomponents-icons/dist/bell.js";
import "@ui5/webcomponents-icons/dist/overflow.js";
import "@ui5/webcomponents-icons/dist/grid.js";
import type { Timeout, ClassMap } from "@ui5/webcomponents-base/dist/types.js";
import type ShellBarItem from "./ShellBarItem.js";
type AccessibilityRoles = {
    logoRole?: string;
};
type AccessibilityTexts = {
    logoTitle?: string;
    profileButtonTitle?: string;
};
type AccessibilityAttributesValue = {
    ariaHasPopup?: string;
    expanded?: boolean;
};
type AccessibilityAttributes = {
    notifications?: AccessibilityAttributesValue;
    profile?: AccessibilityAttributesValue;
    product?: AccessibilityAttributesValue;
    search?: AccessibilityAttributesValue;
    overflow?: AccessibilityAttributesValue;
};
type ShellBarNotificationsClickEventDetail = {
    targetRef: HTMLElement;
};
type ShellBarProfileClickEventDetail = {
    targetRef: HTMLElement;
};
type ShellBarProductSwitchClickEventDetail = {
    targetRef: HTMLElement;
};
type ShellBarLogoClickEventDetail = {
    targetRef: HTMLElement;
};
type ShellBarCoPilotClickEventDetail = {
    targetRef: HTMLElement;
};
type ShellBarMenuItemClickEventDetail = {
    item: HTMLElement;
};
type ShellBarCoPilot = {
    animated?: boolean;
    animationValues?: string;
};
interface IShelBarItemInfo {
    id: string;
    icon?: string;
    text: string;
    priority: number;
    show: boolean;
    count?: string;
    custom?: boolean;
    title?: string;
    stableDomRef?: string;
    refItemid?: string;
    press: (e: MouseEvent) => void;
    styles: object;
    domOrder: number;
    classes: string;
    order?: number;
    profile?: boolean;
}
/**
 * @class
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-shellbar</code> is meant to serve as an application header
 * and includes numerous built-in features, such as: logo, profile image/icon, title, search field, notifications and so on.
 * <br><br>
 *
 * <h3>Stable DOM Refs</h3>
 *
 * You can use the following stable DOM refs for the <code>ui5-shellbar</code>:
 * <ul>
 * <li>logo</li>
 * <li>copilot</li>
 * <li>notifications</li>
 * <li>overflow</li>
 * <li>profile</li>
 * <li>product-switch</li>
 * </ul>
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-shellbar</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>root - Used to style the outermost wrapper of the <code>ui5-shellbar</code></li>
 * </ul>
 *
 * <h3>Keyboard Handling</h3>
 *
 * <h4>Fast Navigation</h4>
 * This component provides a build in fast navigation group which can be used via <code>F6 / Shift + F6</code> or <code> Ctrl + Alt(Option) + Down /  Ctrl + Alt(Option) + Up</code>.
 * In order to use this functionality, you need to import the following module:
 * <code>import "@ui5/webcomponents-base/dist/features/F6Navigation.js"</code>
 * <br><br>
 *
 * <h3>ES6 Module Import</h3>
 * <code>import "@ui5/webcomponents-fiori/dist/ShellBar";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.ShellBar
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-shellbar
 * @appenddocs sap.ui.webc.fiori.ShellBarItem
 * @public
 * @since 0.8.0
 */
declare class ShellBar extends UI5Element {
    /**
     * Defines the <code>primaryTitle</code>.
     * <br><br>
     * <b>Note:</b> The <code>primaryTitle</code> would be hidden on S screen size (less than approx. 700px).
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.fiori.ShellBar.prototype.primaryTitle
     * @public
     */
    primaryTitle: string;
    /**
     * Defines the <code>secondaryTitle</code>.
     * <br><br>
     * <b>Note:</b> The <code>secondaryTitle</code> would be hidden on S and M screen sizes (less than approx. 1300px).
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.fiori.ShellBar.prototype.secondaryTitle
     * @public
     */
    secondaryTitle: string;
    /**
     * Defines the <code>notificationsCount</code>,
     * displayed in the notification icon top-right corner.
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.fiori.ShellBar.prototype.notificationsCount
     * @public
     */
    notificationsCount: string;
    /**
     * Defines, if the notification icon would be displayed.
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.fiori.ShellBar.prototype.showNotifications
     * @public
     */
    showNotifications: boolean;
    /**
     * Defines, if the product switch icon would be displayed.
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.fiori.ShellBar.prototype.showProductSwitch
     * @public
     */
    showProductSwitch: boolean;
    /**
     * Defines, if the product CoPilot icon would be displayed.
     * <br><b>Note:</b> By default the co-pilot is displayed as static SVG.
     * If you need an animated co-pilot, you can import the <code>"@ui5/webcomponents-fiori/dist/features/CoPilotAnimation.js"</code> module as add-on feature.
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.fiori.ShellBar.prototype.showCoPilot
     * @public
     */
    showCoPilot: boolean;
    /**
     * Defines, if the Search Field would be displayed when there is a valid <code>searchField</code> slot.
     * <br><b>Note:</b> By default the Search Field is not displayed.
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.fiori.ShellBar.prototype.showSearchField
     * @public
     */
    showSearchField: boolean;
    /**
     * An object of strings that defines additional accessibility roles for further customization.
     *
     * It supports the following fields:
     *  - <code>logoRole</code>: the accessibility role for the <code>logo</code>
     *
     * @type {object}
     * @name sap.ui.webc.fiori.ShellBar.prototype.accessibilityRoles
     * @public
     * @since 1.6.0
     */
    accessibilityRoles: AccessibilityRoles;
    /**
     * An object of strings that defines several additional accessibility texts
     * for even further customization.
     *
     * It supports the following fields:
     * - <code>profileButtonTitle</code>: defines the tooltip for the profile button
     * - <code>logoTitle</code>: defines the tooltip for the logo
     *
     * @type {object}
     * @name sap.ui.webc.fiori.ShellBar.prototype.accessibilityTexts
     * @public
     * @since 1.1.0
     */
    accessibilityTexts: AccessibilityTexts;
    /**
     * An object of strings that defines several additional accessibility attribute values
     * for customization depending on the use case.
     *
     * It supports the following fields:
     *
     * <ul>
     * 		<li><code>expanded</code>: Indicates whether the anchor element, or another grouping element it controls, is currently expanded or collapsed. Accepts the following string values:
     *			<ul>
     *				<li><code>true</code></li>
     *				<li><code>false</code></li>
     *			</ul>
     * 		</li>
     * 		<li><code>hasPopup</code>: Indicates the availability and type of interactive popup element, such as menu or dialog, that can be triggered by the anchor element. Accepts the following string values:
     * 			<ul>
     *				<li><code>Dialog</code></li>
     *				<li><code>Grid</code></li>
     *				<li><code>ListBox</code></li>
     *				<li><code>Menu</code></li>
     *				<li><code>Tree</code></li>
     * 			</ul>
     * 		</li>
     * </ul>
     * @type {object}
     * @name sap.ui.webc.fiori.ShellBar.prototype.accessibilityAttributes
     * @public
     * @since 1.10.0
     */
    accessibilityAttributes: AccessibilityAttributes;
    /**
     * @private
     */
    breakpointSize: string;
    /**
     * @private
     */
    coPilotActive: boolean;
    /**
     * @private
     */
    withLogo: boolean;
    _itemsInfo: Array<IShelBarItemInfo>;
    _menuPopoverItems: Array<HTMLElement>;
    _menuPopoverExpanded: boolean;
    _overflowPopoverExpanded: boolean;
    _fullWidthSearch: boolean;
    /**
     * Defines the <code>ui5-shellbar</code> aditional items.
     * <br><br>
     * <b>Note:</b>
     * You can use the &nbsp;&lt;ui5-shellbar-item>&lt;/ui5-shellbar-item>.
     *
     * @type {sap.ui.webc.fiori.IShellBarItem[]}
     * @name sap.ui.webc.fiori.ShellBar.prototype.default
     * @slot items
     * @public
     */
    items: Array<ShellBarItem>;
    /**
     * You can pass <code>ui5-avatar</code> to set the profile image/icon.
     * If no profile slot is set - profile will be excluded from actions.
     *
     * Note: We recommend not using the <code>size</code> attribute of <code>ui5-avatar</code> because
     * it should have specific size by design in the context of <code>ui5-shellbar</code> profile.
     * @type {sap.ui.webc.main.IAvatar}
     * @name sap.ui.webc.fiori.ShellBar.prototype.profile
     * @slot profile
     * @since 1.0.0-rc.6
     * @public
     */
    profile: Array<HTMLElement>;
    /**
     * Defines the logo of the <code>ui5-shellbar</code>.
     * For example, you can use <code>ui5-avatar</code> or <code>img</code> elements as logo.
     * @type {sap.ui.webc.main.IAvatar}
     * @name sap.ui.webc.fiori.ShellBar.prototype.logo
     * @slot
     * @since 1.0.0-rc.8
     * @public
     */
    logo: Array<HTMLElement>;
    /**
     * Defines the items displayed in menu after a click on the primary title.
     * <br><br>
     * <b>Note:</b>
     * You can use the &nbsp;&lt;ui5-li>&lt;/ui5-li> and its ancestors.
     *
     * @type {sap.ui.webc.main.IListItem[]}
     * @name sap.ui.webc.fiori.ShellBar.prototype.menuItems
     * @slot
     * @since 0.10
     * @public
     */
    menuItems: Array<HTMLElement>;
    /**
     * Defines the <code>ui5-input</code>, that will be used as a search field.
     *
     * @type {sap.ui.webc.main.IInput}
     * @name sap.ui.webc.fiori.ShellBar.prototype.searchField
     * @slot
     * @public
     */
    searchField: Array<Input>;
    /**
     * Defines a <code>ui5-button</code> in the bar that will be placed in the beginning.
     * We encourage this slot to be used for a back or home button.
     * It gets overstyled to match ShellBar's styling.
     *
     * @type {sap.ui.webc.main.IButton}
     * @name sap.ui.webc.fiori.ShellBar.prototype.startButton
     * @slot
     * @public
     */
    startButton: Array<Button>;
    static i18nBundle: I18nBundle;
    overflowPopover?: Popover | null;
    menuPopover?: Popover | null;
    _isInitialRendering: boolean;
    _defaultItemPressPrevented: boolean;
    menuItemsObserver: MutationObserver;
    coPilot?: ShellBarCoPilot;
    _debounceInterval?: Timeout | null;
    _hiddenIcons?: Array<IShelBarItemInfo>;
    _handleResize: ResizeObserverCallback;
    _headerPress: () => Promise<void>;
    static get FIORI_3_BREAKPOINTS(): number[];
    static get FIORI_3_BREAKPOINTS_MAP(): Record<string, string>;
    constructor();
    _debounce(fn: () => Promise<void>, delay: number): void;
    _menuItemPress(e: CustomEvent<ListSelectionChangeEventDetail>): void;
    _logoPress(): void;
    _menuPopoverBeforeOpen(): void;
    _menuPopoverAfterClose(): void;
    _overflowPopoverBeforeOpen(): void;
    _overflowPopoverAfterClose(): void;
    _logoKeyup(e: KeyboardEvent): void;
    _logoKeydown(e: KeyboardEvent): void;
    _fireCoPilotClick(): void;
    _coPilotClick(): void;
    _coPilotKeydown(e: KeyboardEvent): void;
    _coPilotKeyup(e: KeyboardEvent): void;
    onBeforeRendering(): void;
    onAfterRendering(): void;
    /**
     * Closes the overflow area.
     * Useful to manually close the overflow after having suppressed automatic closing with preventDefault() of ShellbarItem's press event
     * @public
     * @method
     * @name sap.ui.webc.fiori.ShellBar#closeOverflow
     */
    closeOverflow(): void;
    _handleBarBreakpoints(): string;
    _handleSizeS(): void;
    _handleActionsOverflow(): IShelBarItemInfo[];
    _overflowActions(): void;
    _toggleActionPopover(): Promise<void>;
    onEnterDOM(): void;
    onExitDOM(): void;
    _handleSearchIconPress(): void;
    _handleActionListClick(): Promise<void>;
    _handleCustomActionPress(e: MouseEvent): void;
    _handleOverflowPress(): void;
    _handleNotificationsPress(e: MouseEvent): void;
    _handleProfilePress(): void;
    _handleCancelButtonPress(): void;
    _handleProductSwitchPress(e: MouseEvent): void;
    /**
     * Returns the <code>logo</code> DOM ref.
     * @type {HTMLElement}
     * @name sap.ui.webc.fiori.ShellBar.prototype.logoDomRef
     * @public
     * @readonly
     * @since 1.0.0-rc.16
     */
    get logoDomRef(): Button | null;
    /**
     * Returns the <code>copilot</code> DOM ref.
     * @type {HTMLElement}
     * @name sap.ui.webc.fiori.ShellBar.prototype.copilotDomRef
     * @public
     * @readonly
     * @since 1.0.0-rc.16
     */
    get copilotDomRef(): Button | null;
    /**
     * Returns the <code>notifications</code> icon DOM ref.
     * @type {HTMLElement}
     * @name sap.ui.webc.fiori.ShellBar.prototype.notificationsDomRef
     * @public
     * @readonly
     * @since 1.0.0-rc.16
     */
    get notificationsDomRef(): Button | null;
    /**
     * Returns the <code>overflow</code> icon DOM ref.
     * @type {HTMLElement}
     * @name sap.ui.webc.fiori.ShellBar.prototype.overflowDomRef
     * @public
     * @readonly
     * @since 1.0.0-rc.16
     */
    get overflowDomRef(): Button | null;
    /**
     * Returns the <code>profile</code> icon DOM ref.
     * @type {HTMLElement}
     * @name sap.ui.webc.fiori.ShellBar.prototype.profileDomRef
     * @public
     * @readonly
     * @since 1.0.0-rc.16
     */
    get profileDomRef(): Button | null;
    /**
     * Returns the <code>product-switch</code> icon DOM ref.
     * @type {HTMLElement}
     * @name sap.ui.webc.fiori.ShellBar.prototype.productSwitchDomRef
     * @public
     * @readonly
     * @since 1.0.0-rc.16
     */
    get productSwitchDomRef(): Button | null;
    /**
     * Returns all items that will be placed in the right of the bar as icons / dom elements.
     * @param {boolean} showOverflowButton Determines if overflow button should be visible (not overflowing)
     */
    _getAllItems(showOverflowButton: boolean): IShelBarItemInfo[];
    _updateItemsInfo(newItems: Array<IShelBarItemInfo>): void;
    _updateClonedMenuItems(): void;
    _observeMenuItems(): void;
    _getResponsivePopover(): Promise<void>;
    _getOverflowPopover(): Promise<Popover | null>;
    _getMenuPopover(): Promise<Popover | null>;
    isIconHidden(name: string): boolean;
    get classes(): ClassMap;
    get styles(): {
        items: {
            notification: {
                order: string;
            };
            overflow: {
                order: string;
            };
            profile: {
                order: string;
            };
            product: {
                order: string;
            };
        };
        searchField: {
            display: string;
        };
    };
    get correctSearchFieldStyles(): "flex" | "none";
    get customItemsInfo(): IShelBarItemInfo[];
    get hasLogo(): boolean;
    get showLogoInMenuButton(): boolean;
    get showTitleInMenuButton(): boolean | "";
    get showMenuButton(): string | boolean;
    get popoverHorizontalAlign(): "Left" | "Right";
    get hasSearchField(): boolean;
    get hasProfile(): boolean;
    get hasMenuItems(): boolean;
    get _shellbarText(): string;
    get _logoText(): string;
    get _copilotText(): string;
    get _notificationsText(): string;
    get _cancelBtnText(): string;
    get _showFullWidthSearch(): boolean;
    get _profileText(): string;
    get _productsText(): string;
    get _searchText(): string;
    get _overflowText(): string;
    get accInfo(): {
        notifications: {
            title: string;
            accessibilityAttributes: {
                hasPopup: string | null | undefined;
            };
        };
        profile: {
            title: string;
            accessibilityAttributes: {
                hasPopup: string | null | undefined;
            };
        };
        products: {
            title: string;
            accessibilityAttributes: {
                hasPopup: string | null | undefined;
            };
        };
        search: {
            title: string;
            accessibilityAttributes: {
                hasPopup: string | null | undefined;
                expanded: boolean;
            };
        };
        overflow: {
            title: string;
            accessibilityAttributes: {
                hasPopup: string | undefined;
                expanded: boolean;
            };
        };
    };
    get _notificationsHasPopup(): string | null | undefined;
    get _profileHasPopup(): string | null | undefined;
    get _productsHasPopup(): string | null | undefined;
    get _searchHasPopup(): string | null | undefined;
    get _overflowHasPopup(): string | undefined;
    get accLogoRole(): string;
    static onDefine(): Promise<void>;
}
export default ShellBar;
export type { ShellBarNotificationsClickEventDetail, ShellBarProfileClickEventDetail, ShellBarProductSwitchClickEventDetail, ShellBarLogoClickEventDetail, ShellBarCoPilotClickEventDetail, ShellBarMenuItemClickEventDetail, };
