import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
type ShellBarItemClickEventDetail = {
    targetRef: HTMLElement;
};
/**
 * @class
 * The <code>ui5-shellbar-item</code> represents a custom item, that
 * might be added to the <code>ui5-shellbar</code>.
 * <br><br>
 * <h3>ES6 Module Import</h3>
 * <code>import "@ui5/webcomponents-fiori/dist/ShellBarItem";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.ShellBarItem
 * @extends sap.ui.webc.base.UI5Element
 * @abstract
 * @tagname ui5-shellbar-item
 * @implements sap.ui.webc.fiori.IShellBarItem
 * @public
 */
declare class ShellBarItem extends UI5Element {
    /**
     * Defines the name of the item's icon.
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.fiori.ShellBarItem.prototype.icon
     * @public
     */
    icon: string;
    /**
     * Defines the item text.
     * <br><br>
     * <b>Note:</b> The text is only displayed inside the overflow popover list view.
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.fiori.ShellBarItem.prototype.text
     * @public
     */
    text: string;
    /**
     * Defines the count displayed in the top-right corner.
     * @type {string}
     * @defaultValue ""
     * @name sap.ui.webc.fiori.ShellBarItem.prototype.count
     * @since 1.0.0-rc.6
     * @public
     */
    count: string;
    get stableDomRef(): string;
    fireClickEvent(e: MouseEvent): boolean;
}
export default ShellBarItem;
export type { ShellBarItemClickEventDetail };
