import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import ResponsivePopover from "@ui5/webcomponents/dist/ResponsivePopover.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import Tree from "@ui5/webcomponents/dist/Tree.js";
import type { TreeItemClickEventDetail } from "@ui5/webcomponents/dist/Tree.js";
import SideNavigationItem from "./SideNavigationItem.js";
import SideNavigationSubItem from "./SideNavigationSubItem.js";
type SideNavigationPopoverContents = {
    mainItem: SideNavigationItem;
    mainItemSelected: boolean;
    selectedSubItemIndex: number;
    subItems: Array<SideNavigationSubItem>;
};
type TSideNavigationItem = SideNavigationItem | SideNavigationSubItem;
type SideNavigationSelectionChangeEventDetail = {
    item: TSideNavigationItem;
};
type ItemHasAssociatedItemField = {
    item: {
        associatedItem: TSideNavigationItem;
    };
};
type InnerSideNavigationSelectionChangeEventDetail = SideNavigationSelectionChangeEventDetail & ItemHasAssociatedItemField;
type InnerTreeClickEventDetail = TreeItemClickEventDetail & ItemHasAssociatedItemField;
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>SideNavigation</code> is used as a standard menu in applications.
 * It consists of three containers: header (top-aligned), main navigation section (top-aligned) and the secondary section (bottom-aligned).
 * <ul>
 * <li>The header is meant for displaying user related information - profile data, avatar, etc.</li>
 * <li>The main navigation section is related to the user’s current work context</li>
 * <li>The secondary section is mostly used to link additional information that may be of interest (legal information, developer communities, external help, contact information and so on). </li>
 * </ul>
 *
 * <h3>Usage</h3>
 *
 * Use the available <code>ui5-side-navigation-item</code> and <code>ui5-side-navigation-sub-item</code> components to build your menu.
 * The items can consist of text only or an icon with text. The use or non-use of icons must be consistent for all items on one level.
 * You must not combine entries with and without icons on the same level. We strongly recommend that you do not use icons on the second level.
 *
 * <h3>Keyboard Handling</h3>
 *
 * <h4>Fast Navigation</h4>
 * This component provides a build in fast navigation group which can be used via <code>F6 / Shift + F6</code> or <code> Ctrl + Alt(Option) + Down /  Ctrl + Alt(Option) + Up</code>.
 * In order to use this functionality, you need to import the following module:
 * <code>import "@ui5/webcomponents-base/dist/features/F6Navigation.js"</code>
 * <br><br>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents-fiori/dist/SideNavigation.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents-fiori/dist/SideNavigationItem.js";</code> (for <code>ui5-side-navigation-item</code>)
 * <br>
 * <code>import "@ui5/webcomponents-fiori/dist/SideNavigationSubItem.js";</code> (for <code>ui5-side-navigation-sub-item</code>)
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.SideNavigation
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-side-navigation
 * @since 1.0.0-rc.8
 * @appenddocs sap.ui.webc.fiori.SideNavigationItem sap.ui.webc.fiori.SideNavigationSubItem
 * @public
 */
declare class SideNavigation extends UI5Element {
    /**
     * Defines whether the <code>ui5-side-navigation</code> is expanded or collapsed.
     *
     * @public
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.fiori.SideNavigation.prototype.collapsed
     */
    collapsed: boolean;
    /**
     * @private
     */
    _popoverContents: SideNavigationPopoverContents;
    /**
     * Defines the main items of the <code>ui5-side-navigation</code>. Use the <code>ui5-side-navigation-item</code> component
     * for the top-level items, and the <code>ui5-side-navigation-sub-item</code> component for second-level items, nested
     * inside the items.
     *
     * @public
     * @type {sap.ui.webc.fiori.ISideNavigationItem[]}
     * @slot items
     * @name sap.ui.webc.fiori.SideNavigation.prototype.default
     */
    items: Array<SideNavigationItem>;
    /**
     * Defines the header of the <code>ui5-side-navigation</code>.
     *
     * <br><br>
     * <b>Note:</b> The header is displayed when the component is expanded - the property <code>collapsed</code> is false;
     *
     * @public
     * @type {HTMLElement[]}
     * @since 1.0.0-rc.11
     * @slot header
     * @name sap.ui.webc.fiori.SideNavigation.prototype.header
     */
    header: Array<HTMLElement>;
    /**
     * Defines the fixed items at the bottom of the <code>ui5-side-navigation</code>. Use the <code>ui5-side-navigation-item</code> component
     * for the fixed items, and optionally the <code>ui5-side-navigation-sub-item</code> component to provide second-level items inside them.
     *
     * <b>Note:</b> In order to achieve the best user experience, it is recommended that you keep the fixed items "flat" (do not pass sub-items)
     *
     * @public
     * @type {sap.ui.webc.fiori.ISideNavigationItem[]}
     * @slot fixedItems
     * @name sap.ui.webc.fiori.SideNavigation.prototype.fixedItems
     */
    fixedItems: Array<SideNavigationItem>;
    static i18nBundle: I18nBundle;
    get _items(): {
        item: SideNavigationItem;
        selected: boolean;
    }[];
    get _fixedItems(): {
        item: SideNavigationItem;
        selected: boolean;
    }[];
    _createTreeItem: (item: SideNavigationItem) => {
        item: SideNavigationItem;
        selected: boolean;
    };
    _setSelectedItem(item: TSideNavigationItem): void;
    _buildPopoverContent(item: SideNavigationItem): void;
    _onAfterOpen(): Promise<void>;
    get accSideNavigationPopoverHiddenText(): string;
    get ariaRoleDescNavigationList(): string;
    get ariaRoleDescNavigationListItem(): string;
    handleTreeItemClick(e: CustomEvent<InnerTreeClickEventDetail>): void;
    handleInnerSelectionChange(e: CustomEvent<InnerSideNavigationSelectionChangeEventDetail>): void;
    getPicker(): Promise<ResponsivePopover>;
    openPicker(opener: HTMLElement): Promise<void>;
    closePicker(): Promise<void>;
    getPickerTree(): Promise<Tree>;
    get hasHeader(): boolean;
    get showHeader(): boolean;
    get _itemsTree(): Tree | null;
    get _fixedItemsTree(): Tree | null;
    _walk(callback: (current: TSideNavigationItem) => void): void;
    static onDefine(): Promise<void>;
}
export default SideNavigation;
export type { SideNavigationSelectionChangeEventDetail, };
