import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import TimelineLayout from "./types/TimelineLayout.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * An entry posted on the timeline.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.TimelineItem
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-timeline-item
 * @implements sap.ui.webc.fiori.ITimelineItem
 * @public
 */
declare class TimelineItem extends UI5Element implements ITabbable {
    /**
     * Defines the icon to be displayed as graphical element within the <code>ui5-timeline-item</code>.
     * SAP-icons font provides numerous options.
     * <br><br>
     *
     * See all the available icons in the <ui5-link target="_blank" href="https://sdk.openui5.org/test-resources/sap/m/demokit/iconExplorer/webapp/index.html">Icon Explorer</ui5-link>.
     *
     * @type {string}
     * @name sap.ui.webc.fiori.TimelineItem.prototype.icon
     * @defaultvalue ""
     * @public
     */
    icon: string;
    /**
     * Defines the name of the item, displayed before the <code>title-text</code>.
     *
     * @type {string}
     * @name sap.ui.webc.fiori.TimelineItem.prototype.name
     * @defaultvalue ""
     * @public
     */
    name: string;
    /**
     * Defines if the <code>name</code> is clickable.
     *
     * @type {boolean}
     * @name sap.ui.webc.fiori.TimelineItem.prototype.nameClickable
     * @defaultvalue false
     * @public
     */
    nameClickable: boolean;
    /**
     * Defines the title text of the component.
     *
     * @type {string}
     * @name sap.ui.webc.fiori.TimelineItem.prototype.titleText
     * @defaultvalue ""
     * @public
     */
    titleText: string;
    /**
     * Defines the subtitle text of the component.
     * @type {string}
     * @name sap.ui.webc.fiori.TimelineItem.prototype.subtitleText
     * @defaultvalue ""
     * @public
     */
    subtitleText: string;
    _tabIndex: string;
    /**
     * Defines the items orientation.
     *
     * @type {sap.ui.webc.fiori.types.TimelineLayout}
     * @defaultvalue "Vertical"
     * @private
     */
    layout: `${TimelineLayout}`;
    /**
     * Defines the indicator line width.
     *
     * @type {string}
     * @private
     */
    _lineWidth: string;
    /**
     * Determines the description of the <code>ui5-timeline-item</code>.
     *
     * @type {Node[]}
     * @name sap.ui.webc.fiori.TimelineItem.prototype.default
     * @slot
     * @public
     */
    constructor();
    onNamePress(): void;
    /**
     * Focus the internal link.
     * @protected
     */
    focusLink(): void;
    get classes(): {
        indicator: {
            "ui5-tli-indicator": boolean;
            "ui5-tli-indicator-short-line": boolean;
            "ui5-tli-indicator-large-line": boolean;
        };
        bubbleArrowPosition: {
            "ui5-tli-bubble-arrow": boolean;
            "ui5-tli-bubble-arrow--left": boolean;
            "ui5-tli-bubble-arrow--top": boolean;
        };
    };
}
export default TimelineItem;
