import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type { ListSelectionChangeEventDetail } from "@ui5/webcomponents/dist/List.js";
import ListMode from "@ui5/webcomponents/dist/types/ListMode.js";
import "./illustrations/Tent.js";
import "@ui5/webcomponents-icons/dist/upload-to-cloud.js";
import "@ui5/webcomponents-icons/dist/document.js";
import type UploadCollectionItem from "./UploadCollectionItem.js";
import type { DnDEventListener, DnDEventListenerParam } from "./upload-utils/UploadCollectionBodyDnD.js";
import UploadCollectionDnDOverlayMode from "./types/UploadCollectionDnDMode.js";
type UploadCollectionSelectionChangeEventDetail = {
    selectedItems: Array<UploadCollectionItem>;
};
type UploadCollectionItemDeleteEventDetail = {
    item: UploadCollectionItem;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * This component allows you to represent files before uploading them to a server, with the help of <code>ui5-upload-collection-item</code>.
 * It also allows you to show already uploaded files.
 *
 * <h3>ES6 Module Import</h3>
 * <code>import "@ui5/webcomponents-fiori/dist/UploadCollection.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents-fiori/dist/UploadCollectionItem.js";</code> (for <code>ui5-upload-collection-item</code>)
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.UploadCollection
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-upload-collection
 * @appenddocs sap.ui.webc.fiori.UploadCollectionItem
 * @public
 * @since 1.0.0-rc.7
 */
declare class UploadCollection extends UI5Element {
    /**
     * Defines the mode of the <code>ui5-upload-collection</code>.
     *
     * <br><b>Note:</b>
     * Mode "Delete" has no effect. The delete button is controlled by the <code>hideDeleteButton</code> property of UploadCollectionItem</li>
     *
     * @type {sap.ui.webc.main.types.ListMode}
     * @name sap.ui.webc.fiori.UploadCollection.prototype.mode
     * @defaultvalue "None"
     * @public
     */
    mode: `${ListMode}`;
    /**
     * Allows you to set your own text for the 'No data' description.
     *
     * @type {string}
     * @name sap.ui.webc.fiori.UploadCollection.prototype.noDataDescription
     * @defaultvalue ""
     * @public
     */
    noDataDescription: string;
    /**
     * Allows you to set your own text for the 'No data' text.
     *
     * @type {string}
     * @name sap.ui.webc.fiori.UploadCollection.prototype.noDataText
     * @defaultvalue ""
     * @public
     */
    noDataText: string;
    /**
     * By default there will be drag and drop overlay shown over the <code>ui5-upload-collection</code> when files
     * are dragged. If you don't intend to use drag and drop, set this property.
     * <br><br>
     * <b>Note:</b> It is up to the application developer to add handler for <code>drop</code> event and handle it.
     * <code>ui5-upload-collection</code> only displays an overlay.
     *
     * @type {boolean}
     * @name sap.ui.webc.fiori.UploadCollection.prototype.hideDragOverlay
     * @defaultvalue false
     * @public
     */
    hideDragOverlay: boolean;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @name sap.ui.webc.fiori.UploadCollection.prototype.accessibleName
     * @defaultvalue ""
     * @public
     * @since 1.0.0-rc.16
     */
    accessibleName: string;
    /**
     * Indicates what overlay to show when files are being dragged.
     *
     * @type {sap.ui.webc.fiori.types.UploadCollectionDnDOverlayMode}
     * @defaultvalue "None"
     * @private
     */
    _dndOverlayMode: UploadCollectionDnDOverlayMode;
    /**
     * Defines the items of the <code>ui5-upload-collection</code>.
     * <br><b>Note:</b> Use <code>ui5-upload-collection-item</code> for the intended design.
     *
     * @type {sap.ui.webc.fiori.IUploadCollectionItem[]}
     * @name sap.ui.webc.fiori.UploadCollection.prototype.default
     * @slot items
     * @public
     */
    items: Array<UploadCollectionItem>;
    /**
     * Defines the <code>ui5-upload-collection</code> header.
     * <br><br>
     * <b>Note:</b> If <code>header</code> slot is provided,
     * the labelling of the <code>UploadCollection</code> is a responsibility of the application developer.
     * <code>accessibleName</code> should be used.
     *
     * @type {HTMLElement[]}
     * @name sap.ui.webc.fiori.UploadCollection.prototype.header
     * @slot
     * @public
     */
    header: Array<HTMLElement>;
    _bodyDnDHandler: DnDEventListener;
    static i18nBundle: I18nBundle;
    static onDefine(): Promise<void>;
    constructor();
    bodyDnDHandler(e: DnDEventListenerParam): void;
    onEnterDOM(): void;
    onExitDOM(): void;
    _ondragenter(e: DragEvent): void;
    _ondrop(e: DragEvent): void;
    _ondragover(e: DragEvent): void;
    _ondragleave(): void;
    _onItemDelete(e: CustomEvent): void;
    _onSelectionChange(e: CustomEvent<ListSelectionChangeEventDetail>): void;
    get classes(): {
        content: {
            "ui5-uc-content": boolean;
            "ui5-uc-content-no-data": boolean;
        };
        dndOverlay: {
            "uc-dnd-overlay": boolean;
            "uc-drag-overlay": boolean;
            "uc-drop-overlay": boolean;
        };
        noFiles: {
            "uc-no-files": boolean;
            "uc-no-files-dnd-overlay": boolean;
        };
    };
    get _root(): Element | null;
    get _dndOverlay(): Element | null | undefined;
    get _showDndOverlay(): boolean;
    get _showNoData(): boolean;
    get _noDataText(): string;
    get _noDataDescription(): string;
    get _roleDescription(): string;
    get _dndOverlayText(): string;
}
export default UploadCollection;
export type { UploadCollectionItemDeleteEventDetail, UploadCollectionSelectionChangeEventDetail, };
